/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import oracle.oc4j.admin.deploy.gui.AppInfoManager;
import oracle.oc4j.admin.deploy.gui.BooleanDataEntryElement;
import oracle.oc4j.admin.deploy.gui.ComboDataEntryElement;
import oracle.oc4j.admin.deploy.gui.ConnectDialogInfo;
import oracle.oc4j.admin.deploy.gui.DataEntryDialog;
import oracle.oc4j.admin.deploy.gui.DataEntryElement;
import oracle.oc4j.admin.deploy.gui.IntegerDataEntryElement;
import oracle.oc4j.admin.deploy.gui.PasswordDataEntryElement;
import oracle.oc4j.admin.deploy.gui.StringDataEntryElement;

public class ConnectDialog
implements ActionListener {
    protected String _connectChoice = null;
    protected String _oc4j = null;
    protected String _host = null;
    protected Integer _port = null;
    protected String _username = null;
    protected String _password = null;
    protected Boolean _ssl = null;
    ComboDataEntryElement _domainEl = new ComboDataEntryElement("Connection Type", new String[]{"Oc4j Standalone", "OPMN Managed OC4J Instance", "OPMN Managed OC4J Cluster"});
    StringDataEntryElement _oc4jEl = new StringDataEntryElement("OC4J Name");
    StringDataEntryElement _hostEl = new StringDataEntryElement("Host");
    IntegerDataEntryElement _portEl = new IntegerDataEntryElement("Port");
    StringDataEntryElement _userEl = new StringDataEntryElement("Username");
    PasswordDataEntryElement _pwdEl = new PasswordDataEntryElement("Password");
    BooleanDataEntryElement _sslEl = new BooleanDataEntryElement("SSL", false);
    DataEntryDialog _dialog = null;
    private static final int CONNECTION_TYPE_INDEX = 0;
    private static final int OC4J_INDEX = 1;
    private static final int HOST_INDEX = 2;
    private static final int PORT_INDEX = 3;
    private static final int USER_INDEX = 4;
    private static final int PASSWORD_INDEX = 5;
    private static final int SSL_INDEX = 6;
    private static final String ARCHIVE_KEY = "Connect Dialog Info";
    private static final String STANDALONE = "Oc4j Standalone";
    private static final String OPMN_OC4J = "OPMN Managed OC4J Instance";
    private static final String OPMN_CLUSTER = "OPMN Managed OC4J Cluster";

    public ConnectDialog(JFrame parent, String label) {
        ConnectDialogInfo info = (ConnectDialogInfo)AppInfoManager.getStoredObject(ARCHIVE_KEY);
        if (info != null) {
            this._domainEl.setDefaultValue(info.domain);
            this._oc4jEl.setDefaultValue(info.oc4j);
            this._hostEl.setDefaultValue(info.host);
            this._portEl.setDefaultValue(info.port);
            this._userEl.setDefaultValue(info.user);
            this._sslEl.setDefaultValue(info.ssl);
        } else {
            this._portEl.setDefaultValue(new Integer(23791));
        }
        DataEntryElement[] elements = new DataEntryElement[]{this._domainEl, this._oc4jEl, this._hostEl, this._portEl, this._userEl, this._pwdEl, this._sslEl};
        String header = "Connect to a J2EE Platform";
        String title = label == null ? "Enter Login Info for J2EE Platform" : label;
        this._dialog = info != null ? DataEntryDialog.createSimpleDataEntryDialog(elements, 5, header, title) : DataEntryDialog.createSimpleDataEntryDialog(elements, header, title);
        if (this._domainEl.getValueFromComponent() != null && this._domainEl.getValueFromComponent().equals(STANDALONE)) {
            this._dialog.setElementEnabled(1, false);
        }
        ((JComboBox)this._domainEl.getSwingComponent()).addActionListener(this);
        ((JCheckBox)this._sslEl.getSwingComponent()).addActionListener(this);
    }

    public boolean showDialog() {
        if (this._dialog.showDialog()) {
            DataEntryElement[] elements = this._dialog.getDataEntryElements();
            this._connectChoice = elements[0].getValueAsString();
            this._oc4j = elements[1].getValueAsString();
            this._host = elements[2].getValueAsString();
            this._port = (Integer)elements[3].getValue();
            this._username = elements[4].getValueAsString();
            this._password = elements[5].getValueAsString();
            this._ssl = (Boolean)elements[6].getValue();
            ConnectDialogInfo info = new ConnectDialogInfo(this._connectChoice, this._oc4j, this._host, this._port, this._username, this._ssl);
            AppInfoManager.storeObject(ARCHIVE_KEY, info);
            return true;
        }
        return false;
    }

    public boolean isClusterConnection() {
        return this._connectChoice.equals(OPMN_CLUSTER);
    }

    public boolean isOpmnManaged() {
        return !this._connectChoice.equals(STANDALONE);
    }

    public String getOc4j() {
        return this._oc4j;
    }

    public String getHost() {
        return this._host;
    }

    public int getPort() {
        return this._port;
    }

    public String getUsername() {
        return this._username;
    }

    public String getPassword() {
        return this._password;
    }

    public boolean isSsl() {
        return this._ssl;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JComboBox) {
            JComboBox cb = (JComboBox)e.getSource();
            if (cb.getSelectedItem().equals(STANDALONE)) {
                this._dialog.setElementEnabled(1, false);
                this._portEl.setValue(new Integer(23791));
            } else {
                this._dialog.setElementEnabled(1, true);
                this._portEl.setValue(new Integer(6003));
            }
        } else if (((JComboBox)this._domainEl.getSwingComponent()).getSelectedItem().equals(STANDALONE)) {
            JCheckBox cb = (JCheckBox)e.getSource();
            if (cb.isSelected()) {
                this._portEl.setValue(new Integer(23943));
            } else {
                this._portEl.setValue(new Integer(23791));
            }
        }
    }
}

