/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import oracle.oc4j.admin.deploy.gui.AppInfoManager;
import oracle.oc4j.admin.deploy.gui.Controller;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.gui.GuiUtil;

public class DeployMenu
extends JMenuBar
implements ActionListener {
    public static final String OPEN_MENU_STRING = "Open Archive";
    public static final String CLOSE_MENU_STRING = "Close Archive";
    public static final String SAVE_MENU_STRING = "Save Archive";
    public static final String RESTORE_MENU_STRING = "Restore Deployment Plan";
    public static final String FETCH_MENU_STRING = "Fetch Deployment Plan";
    public static final String SHOW_MENU_STRING = "Show Deployment Plan";
    public static final String DEPLOY_MENU_STRING = "Deploy";
    public static final String REDEPLOY_MENU_STRING = "Redeploy";
    public static final String VERIFY_MENU_STRING = "Verify Deployment";
    public static final String EXIT_MENU_STRING = "Exit";
    public static final String CONNECT_MENU_STRING = "Connect to J2EE Server";
    public static final String DISCONNECT_MENU_STRING = "Disconnect from Server";
    public static final int NUM_FILENAMES_IN_MENU = 4;
    protected JMenuItem _openMenuItem;
    protected JMenuItem _closeMenuItem;
    protected JMenuItem _saveMenuItem;
    protected JMenuItem _exitMenuItem;
    protected JMenuItem _restoreMenuItem;
    protected JMenuItem _fetchMenuItem;
    protected JMenuItem _showMenuItem;
    protected JMenuItem _deployMenuItem;
    protected JMenuItem _redeployMenuItem;
    protected JMenuItem _verifyMenuItem;
    protected JMenuItem _connectMenuItem;
    protected JMenuItem _disconnectMenuItem;
    protected JMenu _fileMenu;
    protected JMenu _deployMenu;
    protected Controller _controller;
    protected LinkedList _archiveMenuFiles;
    protected LinkedList _archiveMenuItems;

    public DeployMenu(Controller controller) {
        this._controller = controller;
        this.setFont(GuiUtil.getRegularFont());
        this.setBackground(Deployer.TreeBackgroundColor);
        this._openMenuItem = this.createMenuItem(OPEN_MENU_STRING, 79);
        this._closeMenuItem = this.createMenuItem(CLOSE_MENU_STRING);
        this._saveMenuItem = this.createMenuItem(SAVE_MENU_STRING, 83);
        this._exitMenuItem = this.createMenuItem(EXIT_MENU_STRING, 88);
        this._restoreMenuItem = this.createMenuItem(RESTORE_MENU_STRING);
        this._fetchMenuItem = this.createMenuItem(FETCH_MENU_STRING);
        this._showMenuItem = this.createMenuItem(SHOW_MENU_STRING);
        this._deployMenuItem = this.createMenuItem(DEPLOY_MENU_STRING, 68);
        this._redeployMenuItem = this.createMenuItem(REDEPLOY_MENU_STRING, 82);
        this._verifyMenuItem = this.createMenuItem(VERIFY_MENU_STRING);
        this._connectMenuItem = this.createMenuItem(CONNECT_MENU_STRING, 67);
        this._disconnectMenuItem = this.createMenuItem(DISCONNECT_MENU_STRING);
        this._fileMenu = new JMenu("File");
        this._fileMenu.setBackground(Deployer.TreeBackgroundColor);
        this._fileMenu.setMnemonic(70);
        this._fileMenu.add(this._openMenuItem);
        this._fileMenu.add(this._closeMenuItem);
        this._fileMenu.addSeparator();
        this._fileMenu.add(this._saveMenuItem);
        this._fileMenu.addSeparator();
        this._fileMenu.add(this._exitMenuItem);
        this._archiveMenuFiles = (LinkedList)AppInfoManager.getStoredObject(this.getClass().getName());
        if (this._archiveMenuFiles == null) {
            this._archiveMenuFiles = new LinkedList();
        }
        this._archiveMenuItems = new LinkedList();
        Iterator it = this._archiveMenuFiles.iterator();
        while (it.hasNext()) {
            File file = (File)it.next();
            JMenuItem item = this.createMenuItem(file.getName());
            this._fileMenu.add(item);
            this._archiveMenuItems.addLast(item);
        }
        this._deployMenu = new JMenu("Deployment");
        this._deployMenu.setBackground(Deployer.TreeBackgroundColor);
        this._deployMenu.setMnemonic(68);
        this._deployMenu.add(this._deployMenuItem);
        this._deployMenu.add(this._redeployMenuItem);
        this._deployMenu.addSeparator();
        this._deployMenu.add(this._restoreMenuItem);
        this._deployMenu.add(this._fetchMenuItem);
        this._deployMenu.add(this._showMenuItem);
        this._deployMenu.add(this._verifyMenuItem);
        JMenu connectMenu = new JMenu("Connect");
        connectMenu.setBackground(Deployer.TreeBackgroundColor);
        connectMenu.setMnemonic(67);
        connectMenu.add(this._connectMenuItem);
        connectMenu.add(this._disconnectMenuItem);
        this.archiveClosed();
        this.add(this._fileMenu);
        this.add(this._deployMenu);
        this.add(connectMenu);
        this.archiveClosed();
        this.setConnected(false);
    }

    protected JMenuItem createMenuItem(String text) {
        return this.createMenuItem(text, -1);
    }

    protected JMenuItem createMenuItem(String text, int key) {
        JMenuItem item = null;
        if (key != -1) {
            item = new JMenuItem(text, key);
            item.setAccelerator(KeyStroke.getKeyStroke(key, 8));
        } else {
            item = new JMenuItem(text);
        }
        item.addActionListener(this);
        item.setBackground(Deployer.TreeBackgroundColor);
        return item;
    }

    public void setConnected(boolean flag) {
        this._connectMenuItem.setEnabled(!flag);
        this._disconnectMenuItem.setEnabled(flag);
    }

    public void actionPerformed(ActionEvent e) {
        String menuString = e.getActionCommand();
        if (menuString.equals(OPEN_MENU_STRING)) {
            this._controller.openDeploymentArchive(null);
        } else if (menuString.equals(CLOSE_MENU_STRING)) {
            this._controller.closeDeploymentArchive(true);
        } else if (menuString.equals(SAVE_MENU_STRING)) {
            this._controller.saveDeploymentPlan();
        } else if (menuString.equals(RESTORE_MENU_STRING)) {
            this._controller.restoreDeploymentPlan();
        } else if (menuString.equals(FETCH_MENU_STRING)) {
            this._controller.fetchDeploymentPlan();
        } else if (menuString.equals(SHOW_MENU_STRING)) {
            this._controller.showDeploymentPlan();
        } else if (menuString.equals(DEPLOY_MENU_STRING)) {
            this._controller.deploy();
        } else if (menuString.equals(REDEPLOY_MENU_STRING)) {
            this._controller.redeploy();
        } else if (menuString.equals(VERIFY_MENU_STRING)) {
            this._controller.verifyDeploymentConfiguration();
        } else if (menuString.equals(CONNECT_MENU_STRING)) {
            this._controller.connect();
        } else if (menuString.equals(DISCONNECT_MENU_STRING)) {
            this._controller.disconnect();
        } else if (menuString.equals(EXIT_MENU_STRING)) {
            this._controller.exit(1);
        } else {
            for (int i = 0; i < 4; ++i) {
                String menuItemText = ((JMenuItem)this._archiveMenuItems.get(i)).getText();
                if (!menuItemText.equals(menuString)) continue;
                File archive = (File)this._archiveMenuFiles.get(i);
                if (this._controller.openDeploymentArchive(archive)) break;
                this._archiveMenuFiles.remove(i);
                JMenuItem menuItem = (JMenuItem)this._archiveMenuItems.remove(i);
                this._fileMenu.remove(menuItem);
                break;
            }
        }
    }

    public void archiveOpen(File openArchive) {
        this._closeMenuItem.setEnabled(true);
        this._saveMenuItem.setEnabled(true);
        this._restoreMenuItem.setEnabled(true);
        this._fetchMenuItem.setEnabled(true);
        this._showMenuItem.setEnabled(true);
        this._deployMenuItem.setEnabled(true);
        this._redeployMenuItem.setEnabled(true);
        this._verifyMenuItem.setEnabled(true);
        if (this._archiveMenuFiles.contains(openArchive)) {
            int index = this._archiveMenuFiles.indexOf(openArchive);
            if (index != 0) {
                int total = this._fileMenu.getItemCount();
                int firstArchivePos = total - this._archiveMenuFiles.size();
                this._archiveMenuFiles.remove(openArchive);
                this._archiveMenuFiles.addFirst(openArchive);
                JMenuItem menuItem = (JMenuItem)this._archiveMenuItems.remove(index);
                this._archiveMenuItems.addFirst(menuItem);
                this._fileMenu.remove(menuItem);
                this._fileMenu.insert(menuItem, firstArchivePos);
            }
        } else {
            if (this._archiveMenuItems.size() == 4) {
                this._archiveMenuFiles.removeFirst();
                this._fileMenu.remove((JMenuItem)this._archiveMenuItems.removeFirst());
            }
            JMenuItem archiveMenuItem = this.createMenuItem(openArchive.getName());
            this._archiveMenuFiles.addLast(openArchive);
            this._archiveMenuItems.addLast(archiveMenuItem);
            this._fileMenu.add(archiveMenuItem);
            AppInfoManager.storeObject(this.getClass().getName(), this._archiveMenuFiles);
        }
    }

    public void archiveClosed() {
        this._closeMenuItem.setEnabled(false);
        this._saveMenuItem.setEnabled(false);
        this._restoreMenuItem.setEnabled(false);
        this._fetchMenuItem.setEnabled(false);
        this._showMenuItem.setEnabled(false);
        this._deployMenuItem.setEnabled(false);
        this._redeployMenuItem.setEnabled(false);
        this._verifyMenuItem.setEnabled(false);
    }
}

