/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import oracle.oc4j.admin.deploy.gui.GuiUtil;
import oracle.oc4j.admin.deploy.gui.ImportSharedLibraryRootNode;
import oracle.oc4j.admin.deploy.gui.RemoveableNode;
import oracle.oc4j.admin.deploy.gui.SharedLibraryNode;
import oracle.oc4j.admin.deploy.gui.ViewableJTreeNodeSupport;
import oracle.oc4j.admin.deploy.spi.ProprietaryConnectedDeploymentManager;
import oracle.oc4j.admin.management.shared.ImportSharedLibrary;

public class ImportSharedLibraryNode
extends ViewableJTreeNodeSupport
implements RemoveableNode {
    protected ImportSharedLibrary _importSharedLibrary;
    protected DeploymentManager _manager;

    public ImportSharedLibraryNode(ImportSharedLibrary importSharedLibrary, DeploymentManager manager) {
        this._importSharedLibrary = importSharedLibrary;
        this._manager = manager;
    }

    public String getName() {
        return this._importSharedLibrary.getName();
    }

    public String getMinVersion() {
        return this._importSharedLibrary.getMinVersion();
    }

    public String getMaxVersion() {
        return this._importSharedLibrary.getMaxVersion();
    }

    public boolean removeNode() {
        String title = "Confirm Remove Import";
        String message = "Remove Import '" + this.getName() + "'?";
        if (GuiUtil.showYesNoDialog(title, message) != 0) {
            return false;
        }
        try {
            ImportSharedLibraryRootNode parent = (ImportSharedLibraryRootNode)this.getParent();
            SharedLibraryNode parentLib = (SharedLibraryNode)parent.getParent();
            ProprietaryConnectedDeploymentManager mgr = (ProprietaryConnectedDeploymentManager)this._manager;
            mgr.modifySharedLibrary(new Target[]{parentLib.getTarget()}, parentLib.getName(), parentLib.getVersion(), null, null, null, null, null, new String[]{this.getName()});
        }
        catch (Exception ex) {
            GuiUtil.errDialog("Exception removing import: " + ex.getMessage());
            ex.printStackTrace();
            return false;
        }
        ((ViewableJTreeNodeSupport)this.getParent()).removeJTreeChild(this);
        return true;
    }

    public String jtreeToolTip() {
        return this.viewHeaderString();
    }

    public String viewHeaderString() {
        return this.getName() + "   (Import Shared Library)";
    }

    public String toString() {
        return this.getName();
    }

    public void buildChildJTree() {
    }

    public boolean leaf() {
        return true;
    }
}

