/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import javax.enterprise.deploy.spi.DeploymentManager;
import javax.management.ObjectName;
import javax.management.j2ee.Management;
import oracle.oc4j.admin.deploy.gui.GuiUtil;
import oracle.oc4j.admin.deploy.gui.JVMNode;
import oracle.oc4j.admin.deploy.gui.ViewableJTreeNodeSupport;
import oracle.oc4j.admin.deploy.spi.ConnectedDeploymentManagerBase;

public class IslandNode
extends ViewableJTreeNodeSupport {
    private ObjectName _objectName;
    private String _islandName;
    private DeploymentManager _manager;
    private String _hostName;

    public IslandNode(ObjectName objName, String islandName, DeploymentManager manager) throws Exception {
        this._objectName = objName;
        this._islandName = islandName;
        this._manager = manager;
        Management mejb = ((ConnectedDeploymentManagerBase)manager).getMEJB();
        this._hostName = (String)mejb.getAttribute(this._objectName, "node");
    }

    public String getName() {
        return this._islandName;
    }

    public String getHost() {
        return this._hostName;
    }

    public String jtreeIconName() {
        return "island";
    }

    public String jtreeToolTip() {
        return this.viewHeaderString();
    }

    public String viewHeaderString() {
        return "OC4J Island";
    }

    public String toString() {
        return this.getName();
    }

    public void buildChildJTree() {
        try {
            Management mejb = ((ConnectedDeploymentManagerBase)this._manager).getMEJB();
            ObjectName[] jvms = (ObjectName[])mejb.getAttribute(this._objectName, "OC4JProcs");
            for (int i = 0; i < jvms.length; ++i) {
                String islandName = (String)mejb.getAttribute(jvms[i], "island");
                if (!islandName.equals(this._islandName)) continue;
                this.addJTreeChild(new JVMNode(jvms[i], this._manager));
            }
        }
        catch (Exception ex) {
            GuiUtil.errDialog("Exception getting JVM info: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    public boolean leaf() {
        return false;
    }
}

