/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import javax.enterprise.deploy.spi.DeploymentManager;
import javax.management.ObjectName;
import javax.management.j2ee.Management;
import oracle.oc4j.admin.deploy.gui.DataSourceNode;
import oracle.oc4j.admin.deploy.gui.GuiUtil;
import oracle.oc4j.admin.deploy.gui.ViewableJTreeNodeSupport;
import oracle.oc4j.admin.deploy.spi.ConnectedDeploymentManagerBase;
import oracle.oc4j.admin.deploy.spi.DataSourceInfoImpl;

public class ServerDataSourceRootNode
extends ViewableJTreeNodeSupport {
    private ObjectName _objectName;
    private DeploymentManager _manager;
    private String _viewHeaderString;

    public ServerDataSourceRootNode(String server, ObjectName objName, DeploymentManager manager) {
        this._viewHeaderString = "JDBC Data Sources Defined for Cluster " + server;
        this._manager = manager;
        this._objectName = objName;
    }

    public String viewHeaderString() {
        return this._viewHeaderString;
    }

    public String toString() {
        return "JDBC Data Sources";
    }

    public void buildChildJTree() {
        try {
            Management mejb = ((ConnectedDeploymentManagerBase)this._manager).getMEJB();
            ObjectName[] oc4js = (ObjectName[])mejb.getAttribute(this._objectName, "Resources");
            for (int i = 0; i < oc4js.length; ++i) {
                String[] dsr;
                if (oc4js[i].toString().indexOf("JDBCResource") == -1 || (dsr = (String[])mejb.getAttribute(oc4js[i], "jdbcDataSources")) == null) continue;
                for (int j = 0; j < dsr.length; ++j) {
                    this.addJTreeChild(new DataSourceNode(new DataSourceInfoImpl(mejb, oc4js[i], new ObjectName(dsr[j]))));
                }
            }
        }
        catch (Exception ex) {
            GuiUtil.errDialog("Exception getting resource info: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    public boolean leaf() {
        return false;
    }
}

