/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import oracle.oc4j.admin.deploy.gui.CodeSourceRootNode;
import oracle.oc4j.admin.deploy.gui.GuiUtil;
import oracle.oc4j.admin.deploy.gui.ImportSharedLibraryRootNode;
import oracle.oc4j.admin.deploy.gui.InstantiateableNode;
import oracle.oc4j.admin.deploy.gui.RemoveableNode;
import oracle.oc4j.admin.deploy.gui.ViewableJTreeNodeSupport;
import oracle.oc4j.admin.deploy.spi.ProprietaryTarget;
import oracle.oc4j.admin.management.shared.SharedLibrary;

public class SharedLibraryNode
extends ViewableJTreeNodeSupport
implements RemoveableNode,
InstantiateableNode {
    protected Target _target;
    protected DeploymentManager _manager;
    protected SharedLibrary _sharedLibrary;

    public SharedLibraryNode(Target target, DeploymentManager manager, SharedLibrary sharedLibrary) {
        this._target = target;
        this._manager = manager;
        this._sharedLibrary = sharedLibrary;
    }

    public SharedLibrary getSharedLibrary() {
        return this._sharedLibrary;
    }

    public Target getTarget() {
        return this._target;
    }

    public String getName() {
        return this._sharedLibrary.getName();
    }

    public String getVersion() {
        return this._sharedLibrary.getVersion();
    }

    public String getParentName() {
        return this._sharedLibrary.getParentName();
    }

    public String getParentVersion() {
        return this._sharedLibrary.getParentVersion();
    }

    public boolean isModifiable() {
        return this._sharedLibrary.isModifiable();
    }

    public boolean isInstantiated() {
        return this._sharedLibrary.isInstantiated();
    }

    public boolean isLibraryCompatible() {
        return this._sharedLibrary.isLibraryCompatible();
    }

    public boolean removeNode() {
        ((ViewableJTreeNodeSupport)this.getParent()).setRebuildChildJTree(true);
        String title = "Confirm Remove Shared Library";
        String message = "Remove Shared Library '" + this.getName() + "'?";
        if (GuiUtil.showYesNoDialog(title, message) != 0) {
            return false;
        }
        try {
            ((ProprietaryTarget)this._target).removeSharedLibrary(this.getName(), this.getVersion());
        }
        catch (Exception ex) {
            GuiUtil.errDialog("Exception removing shared library: " + ex.getMessage());
            ex.printStackTrace();
            return false;
        }
        ((ViewableJTreeNodeSupport)this.getParent()).removeJTreeChild(this);
        return true;
    }

    public boolean instantiateNode() {
        ((ViewableJTreeNodeSupport)this.getParent()).setRebuildChildJTree(true);
        String title = "Confirm Instantiate Shared Library";
        String message = "Instantiate Shared Library '" + this.getName() + "'?";
        if (GuiUtil.showYesNoDialog(title, message) != 0) {
            return false;
        }
        boolean ret = false;
        try {
            ret = ((ProprietaryTarget)this._target).instantiateSharedLibrary(this.getName(), this.getVersion());
        }
        catch (Exception ex) {
            GuiUtil.errDialog("Exception instantiating shared library: " + ex.getMessage());
            ex.printStackTrace();
            return false;
        }
        return ret;
    }

    public String jtreeToolTip() {
        return this.viewHeaderString();
    }

    public String viewHeaderString() {
        return this.getName() + "   (Shared Library)";
    }

    public String toString() {
        return this.getName();
    }

    public void buildChildJTree() {
        this.addJTreeChild(new CodeSourceRootNode(this._sharedLibrary.getCodeSources(), this._manager));
        this.addJTreeChild(new ImportSharedLibraryRootNode(this._sharedLibrary.getImports(), this._manager));
    }

    public boolean leaf() {
        return false;
    }
}

