/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.swing.JComboBox;
import oracle.oc4j.admin.deploy.gui.BooleanDataEntryElement;
import oracle.oc4j.admin.deploy.gui.ComboDataEntryElement;
import oracle.oc4j.admin.deploy.gui.DataEntryDialog;
import oracle.oc4j.admin.deploy.gui.DataEntryElement;
import oracle.oc4j.admin.deploy.gui.FileListDataEntryElement;
import oracle.oc4j.admin.deploy.gui.GuiUtil;
import oracle.oc4j.admin.deploy.gui.ImportLibDataEntryElement;
import oracle.oc4j.admin.deploy.gui.ListDataEntryElement;
import oracle.oc4j.admin.deploy.gui.ModifiableRootNode;
import oracle.oc4j.admin.deploy.gui.RefreshableNode;
import oracle.oc4j.admin.deploy.gui.SharedLibraryNode;
import oracle.oc4j.admin.deploy.gui.StringDataEntryElement;
import oracle.oc4j.admin.deploy.gui.ViewableJTreeNode;
import oracle.oc4j.admin.deploy.gui.ViewableJTreeNodeSupport;
import oracle.oc4j.admin.deploy.spi.ProprietaryConnectedDeploymentManager;
import oracle.oc4j.admin.deploy.spi.ProprietaryTarget;
import oracle.oc4j.admin.management.shared.ImportSharedLibrary;
import oracle.oc4j.admin.management.shared.SharedLibrary;

public class SharedLibraryRootNode
extends ViewableJTreeNodeSupport
implements ModifiableRootNode,
RefreshableNode {
    protected String _viewHeaderString;
    protected Target _target;
    protected DeploymentManager _manager;
    protected SharedLibrary[] _sharedLibraries;
    ComboDataEntryElement pVersionElem;

    public SharedLibraryRootNode(Target target, DeploymentManager manager) {
        this._viewHeaderString = "Shared Libraries for " + target.getName();
        this._target = target;
        this._manager = manager;
    }

    public SharedLibrary[] getSharedLibraries() {
        ProprietaryTarget pt = (ProprietaryTarget)this._target;
        this._sharedLibraries = pt.getSharedLibraries();
        return this._sharedLibraries;
    }

    public String childType() {
        return "Shared Library";
    }

    public ViewableJTreeNode addNewChildNode() {
        ProprietaryTarget pt = (ProprietaryTarget)this._target;
        SharedLibrary[] shLibs = pt.getSharedLibraries();
        Object[] shLibs2 = new SharedLibrary[shLibs.length + 1];
        shLibs2[0] = new SharedLibrary("", "1.0", null, null);
        for (int i = 0; i < shLibs.length; ++i) {
            shLibs2[i + 1] = shLibs[i];
        }
        StringDataEntryElement nameElem = new StringDataEntryElement("Name");
        StringDataEntryElement versionElem = new StringDataEntryElement("Version");
        ComboDataEntryElement pNameElem = new ComboDataEntryElement("ParentName", shLibs2, true);
        this.pVersionElem = new ComboDataEntryElement("ParentVersion", new Object[0], true);
        BooleanDataEntryElement libraryCompatibleElem = new BooleanDataEntryElement("LibraryCompatible", false);
        FileListDataEntryElement uploadCodeSourceElem = new FileListDataEntryElement("Code Source");
        ListDataEntryElement addCodeSourceElem = new ListDataEntryElement("Code Source");
        ImportLibDataEntryElement imports = new ImportLibDataEntryElement("Import Library", shLibs);
        ((JComboBox)pNameElem.getSwingComponent()).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox name = (JComboBox)e.getSource();
                String libName = name.getSelectedItem().toString();
                if (libName.length() == 0) {
                    SharedLibraryRootNode.this.pVersionElem.setValueInComponent(new String[]{""});
                    return;
                }
                ProprietaryTarget pt = (ProprietaryTarget)SharedLibraryRootNode.this._target;
                SharedLibrary[] shLibs = pt.getSharedLibraries();
                Vector<String> versions = new Vector<String>();
                for (int i = 0; i < shLibs.length; ++i) {
                    if (!shLibs[i].getName().equals(libName)) continue;
                    versions.add(shLibs[i].getVersion());
                }
                SharedLibraryRootNode.this.pVersionElem.setValueInComponent(versions.toArray());
            }
        });
        DataEntryElement[] childElements = new DataEntryElement[]{nameElem, versionElem, pNameElem, this.pVersionElem, libraryCompatibleElem};
        DataEntryDialog firstDialog = DataEntryDialog.createSimpleProgressiveDataEntryDialog(childElements, "New " + this.childType(), "Enter New " + this.childType() + " Information", false, true);
        DataEntryElement[] uploadCodeSources = new DataEntryElement[]{uploadCodeSourceElem};
        DataEntryDialog secondDialog = DataEntryDialog.createSimpleProgressiveDataEntryDialog(uploadCodeSources, "Code Sources", "Specify New Code Sources to Upload", true, true);
        DataEntryElement[] addCodeSources = new DataEntryElement[]{addCodeSourceElem};
        DataEntryDialog thirdDialog = DataEntryDialog.createSimpleProgressiveDataEntryDialog(addCodeSources, "Code Sources", "Specify Existing Code Sources to Add", true, true);
        DataEntryElement[] addImports = new DataEntryElement[]{imports};
        DataEntryDialog fourthDialog = DataEntryDialog.createSimpleProgressiveDataEntryDialog(addImports, "Shared Library Imports", "Specify Shared Libraries to Import", true, false);
        firstDialog.setNextDialog(secondDialog);
        secondDialog.setPreviousDialog(firstDialog);
        secondDialog.setNextDialog(thirdDialog);
        thirdDialog.setPreviousDialog(secondDialog);
        thirdDialog.setNextDialog(fourthDialog);
        fourthDialog.setPreviousDialog(thirdDialog);
        if (!firstDialog.showDialog()) {
            return null;
        }
        String name = nameElem.getValueAsString();
        String version = versionElem.getValueAsString();
        String parentName = pNameElem.getValueAsString();
        String parentVersion = this.pVersionElem.getValueAsString();
        Boolean libraryCompatible = (Boolean)libraryCompatibleElem.getValueFromComponent();
        File[] codeSourceFiles = (File[])uploadCodeSourceElem.getValue();
        String[] codeSources = (String[])addCodeSourceElem.getValue();
        ImportSharedLibrary[] importLibs = (ImportSharedLibrary[])imports.getValue();
        while (codeSourceFiles.length == 0 && codeSources.length == 0 && importLibs.length == 0) {
            GuiUtil.errDialog("Shared Library must contain at least 1 code source or import library.");
            if (fourthDialog.showDialog()) continue;
            return null;
        }
        try {
            this.getSharedLibraries();
            for (int lib = 0; lib < this._sharedLibraries.length; ++lib) {
                if (!this._sharedLibraries[lib].getName().equals(name) || !this._sharedLibraries[lib].getVersion().equals(version)) continue;
                GuiUtil.errDialog("Shared Library already exists.");
                return null;
            }
            ProprietaryConnectedDeploymentManager mgr = (ProprietaryConnectedDeploymentManager)this._manager;
            mgr.publishSharedLibrary(new Target[]{this._target}, name, version, parentName, parentVersion, libraryCompatible, codeSourceFiles, codeSources, importLibs);
            this.getSharedLibraries();
            this.setRebuildChildJTree(true);
            SharedLibrary newLib = null;
            for (int i = 0; i < this._sharedLibraries.length; ++i) {
                if (!this._sharedLibraries[i].getName().equals(name) || !this._sharedLibraries[i].getVersion().equals(version)) continue;
                newLib = this._sharedLibraries[i];
                break;
            }
            SharedLibraryNode node = new SharedLibraryNode(this._target, this._manager, newLib);
            this.addJTreeChild(node);
            return node;
        }
        catch (Exception ex) {
            GuiUtil.errDialog("Exception adding " + this.childType() + ": " + ex.getMessage());
            ex.printStackTrace();
            return null;
        }
    }

    public String viewHeaderString() {
        return this._viewHeaderString;
    }

    public String toString() {
        return "Shared Libraries";
    }

    public boolean refreshNode() {
        this.setRebuildChildJTree(true);
        return true;
    }

    public void buildChildJTree() {
        ProprietaryTarget pt = (ProprietaryTarget)this._target;
        this._sharedLibraries = pt.getSharedLibraries();
        for (int lib = 0; lib < this._sharedLibraries.length; ++lib) {
            this.addJTreeChild(new SharedLibraryNode(this._target, this._manager, this._sharedLibraries[lib]));
        }
    }

    public boolean leaf() {
        return false;
    }
}

