/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.oc4j.admin.deploy.gui.AppInfoManager;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.gui.GuiUtil;

public class UploadSharedLibOptionsDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    protected static final String OK_STRING = "OK";
    protected static final String CANCEL_STRING = "Cancel";
    protected static final String CHOOSE_CODE_SOURCE_STRING = "Choose Code Source";
    protected static final String REMOVE_CODE_SOURCE_STRING = "Remove Code Source";
    protected JTextField _nameField = null;
    protected JTextField _versionField = null;
    protected JTextField _codeSourceField = null;
    protected String _name;
    protected String _version;
    protected String _codeSource;
    protected Vector _files = new Vector();
    protected DefaultListModel _model;
    protected DefaultListSelectionModel _selectionModel;
    protected int _selectedIndex = -1;
    protected boolean _response;
    protected int height = 400;

    public UploadSharedLibOptionsDialog(JFrame parent) {
        super((Frame)parent, "Upload Shared Library");
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setBackground(Deployer.TreeBackgroundColor);
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.setBorder(BorderFactory.createEmptyBorder(20, 15, 15, 15));
        String labelString = "Enter the name for the library:";
        JLabel titleLabel = new JLabel(labelString, 0);
        JPanel labelPane1 = new JPanel();
        labelPane1.setOpaque(false);
        labelPane1.setLayout(new BorderLayout());
        labelPane1.add((Component)titleLabel, "Center");
        contentPane.add(labelPane1);
        contentPane.add(Box.createRigidArea(new Dimension(0, 10)));
        this._nameField = new JTextField();
        contentPane.add(this._nameField);
        contentPane.add(Box.createRigidArea(new Dimension(0, 10)));
        labelString = "Enter the version for the library:";
        JLabel replaceLabel = new JLabel(labelString, 0);
        JPanel labelPane2 = new JPanel();
        labelPane2.setOpaque(false);
        labelPane2.setLayout(new BorderLayout());
        labelPane2.add((Component)replaceLabel, "Center");
        contentPane.add(labelPane2);
        contentPane.add(Box.createRigidArea(new Dimension(0, 10)));
        this._versionField = new JTextField();
        contentPane.add(this._versionField);
        contentPane.add(Box.createRigidArea(new Dimension(0, 10)));
        JLabel codeSourcesLabel = new JLabel("Code Sources", 0);
        JPanel labelPane3 = new JPanel();
        labelPane3.setOpaque(false);
        labelPane3.setLayout(new BorderLayout());
        labelPane3.add((Component)codeSourcesLabel, "Center");
        contentPane.add(labelPane3);
        contentPane.add(Box.createRigidArea(new Dimension(0, 10)));
        this._model = new DefaultListModel();
        JList list = new JList(this._model);
        JScrollPane scrollPane = new JScrollPane(list);
        contentPane.add(scrollPane);
        contentPane.add(Box.createRigidArea(new Dimension(0, 10)));
        this._selectionModel = new DefaultListSelectionModel();
        this._selectionModel.setSelectionMode(0);
        list.setSelectionModel(this._selectionModel);
        list.addListSelectionListener(this);
        this.setSize(new Dimension(450, this.height));
        this.setModal(true);
        JPanel buttonPane1 = new JPanel();
        buttonPane1.setOpaque(false);
        JPanel buttonPane2 = new JPanel();
        buttonPane2.setOpaque(false);
        JButton chooseCodeSourceButton = new JButton(CHOOSE_CODE_SOURCE_STRING);
        chooseCodeSourceButton.setActionCommand(CHOOSE_CODE_SOURCE_STRING);
        chooseCodeSourceButton.addActionListener(this);
        JButton removeCodeSourceButton = new JButton(REMOVE_CODE_SOURCE_STRING);
        removeCodeSourceButton.setActionCommand(REMOVE_CODE_SOURCE_STRING);
        removeCodeSourceButton.addActionListener(this);
        JButton okButton = new JButton(OK_STRING);
        okButton.setActionCommand(OK_STRING);
        okButton.addActionListener(this);
        JButton cancelButton = new JButton(CANCEL_STRING);
        cancelButton.setActionCommand(CANCEL_STRING);
        cancelButton.addActionListener(this);
        buttonPane1.add(chooseCodeSourceButton);
        buttonPane1.add(removeCodeSourceButton);
        buttonPane2.add(okButton);
        buttonPane2.add(cancelButton);
        contentPane.add(buttonPane1);
        contentPane.add(Box.createRigidArea(new Dimension(0, 10)));
        contentPane.add(buttonPane2);
        this.getRootPane().setDefaultButton(okButton);
        this.setLocationRelativeTo(parent);
    }

    public boolean showDialog() {
        this.show();
        return this._response;
    }

    public void valueChanged(ListSelectionEvent e) {
        for (int sel = e.getFirstIndex(); sel <= e.getLastIndex(); ++sel) {
            if (!this._selectionModel.isSelectedIndex(sel)) continue;
            this._selectedIndex = sel;
            break;
        }
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals(CANCEL_STRING)) {
            this._response = false;
            this.dispose();
        } else if (actionCommand.equals(CHOOSE_CODE_SOURCE_STRING)) {
            String name;
            File file = this.promptUserToSpecifyFile();
            if (file != null && (name = file.getName()) != null && name.length() > 0) {
                for (int n = 0; n < this._files.size(); ++n) {
                    if (!name.equals(((File)this._files.elementAt(n)).getName())) continue;
                    return;
                }
                this._files.add(file);
                this._model.addElement(file.getName());
                this._selectionModel.setSelectionInterval(this._files.size() - 1, this._files.size() - 1);
            }
        } else if (actionCommand.equals(REMOVE_CODE_SOURCE_STRING)) {
            if (this._selectedIndex >= 0) {
                this._model.removeElementAt(this._selectedIndex);
                this._files.removeElementAt(this._selectedIndex);
                this._selectionModel.clearSelection();
                this._selectedIndex = -1;
            }
        } else {
            if (this._nameField != null) {
                this._name = this._nameField.getText().trim();
                if (this._name == null || this._name.equals("")) {
                    GuiUtil.errDialog("You must enter a name.");
                    return;
                }
            }
            if (this._versionField != null) {
                this._version = this._versionField.getText().trim();
                if (this._version == null || this._version.equals("")) {
                    GuiUtil.errDialog("You must enter a version.");
                    return;
                }
            }
            if (this._codeSourceField != null) {
                this._codeSource = this._codeSourceField.getText().trim();
                if (this._codeSource == null || this._codeSource.equals("")) {
                    GuiUtil.errDialog("You must enter a code source.");
                    return;
                }
            }
            this._response = true;
            this.dispose();
        }
    }

    public String getName() {
        return this._name;
    }

    public String getVersion() {
        return this._version;
    }

    public Vector getFiles() {
        return this._files;
    }

    protected File promptUserToSpecifyFile() {
        int retVal;
        JFileChooser chooser = new JFileChooser();
        File lastDir = (File)AppInfoManager.getStoredObject(JFileChooser.class.getName());
        if (lastDir != null) {
            chooser.setCurrentDirectory(lastDir);
        }
        if ((retVal = chooser.showOpenDialog(this)) == 1 || retVal == -1) {
            return null;
        }
        AppInfoManager.storeObject(JFileChooser.class.getName(), chooser.getCurrentDirectory());
        return chooser.getSelectedFile();
    }
}

