/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.xml;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import oracle.oc4j.admin.deploy.model.xml.BeanNode;
import oracle.oc4j.admin.deploy.model.xml.CollectionJTreeNode;
import oracle.oc4j.admin.deploy.model.xml.ConfigPropertyBean;
import oracle.oc4j.admin.deploy.model.xml.StringBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConnectionDefinition15Bean
extends BeanNode {
    public ConnectionDefinition15Bean(Node node, DDBean parent) {
        super(node, parent);
        this.init(node);
    }

    public String getManagedConnectionFactoryClass() {
        return this.nodeValue("managedconnectionfactory-class");
    }

    public String getConnectionFactoryInterface() {
        return this.nodeValue("connectionfactory-interface");
    }

    public String getConnectionFactoryImplClass() {
        return this.nodeValue("connectionfactory-impl-class");
    }

    public String getConnectionInterface() {
        return this.nodeValue("connection-interface");
    }

    public String getConnectionImplClass() {
        return this.nodeValue("connection-impl-class");
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        out.println(indentation + "<" + "connection-definition" + ">");
        ConnectionDefinition15Bean.writeAll(this.getChildBean("managedconnectionfactory-class"), out, indentation + "\t");
        ConnectionDefinition15Bean.writeAll(this.getChildBean("config-property"), out, indentation + "\t");
        ConnectionDefinition15Bean.writeAll(this.getChildBean("connectionfactory-interface"), out, indentation + "\t");
        ConnectionDefinition15Bean.writeAll(this.getChildBean("connectionfactory-impl-class"), out, indentation + "\t");
        ConnectionDefinition15Bean.writeAll(this.getChildBean("connection-interface"), out, indentation + "\t");
        ConnectionDefinition15Bean.writeAll(this.getChildBean("connection-impl-class"), out, indentation + "\t");
        out.println(indentation + "</" + "connection-definition" + ">");
    }

    protected Collection createSpecialJTreeChildren() {
        Vector<CollectionJTreeNode> vec = new Vector<CollectionJTreeNode>();
        vec.add(new CollectionJTreeNode(this, "config-property", "Config Properties", true));
        return vec;
    }

    public String toString() {
        return "Connection Definition";
    }

    private void init(Node rootNode) {
        this.setXpath("connection-definition");
        Vector<StringBean> managedConnectionFactoryClass = new Vector<StringBean>(1);
        Vector<StringBean> connectionFactoryInterface = new Vector<StringBean>(1);
        Vector<StringBean> connectionFactoryImplClass = new Vector<StringBean>(1);
        Vector<StringBean> connectionInterface = new Vector<StringBean>(1);
        Vector<StringBean> connectionImplClass = new Vector<StringBean>(1);
        Vector<StringBean> configProperty = new Vector<StringBean>();
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            BeanNode bean;
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("managedconnectionfactory-class")) {
                bean = new StringBean(node, this, "managedconnectionfactory-class");
                managedConnectionFactoryClass.add((StringBean)bean);
                continue;
            }
            if (name.equals("connectionfactory-interface")) {
                bean = new StringBean(node, this, "connectionfactory-interface");
                connectionFactoryInterface.add((StringBean)bean);
                continue;
            }
            if (name.equals("connectionfactory-impl-class")) {
                bean = new StringBean(node, this, "connectionfactory-impl-class");
                connectionFactoryImplClass.add((StringBean)bean);
                continue;
            }
            if (name.equals("connection-interface")) {
                bean = new StringBean(node, this, "connection-interface");
                connectionInterface.add((StringBean)bean);
                continue;
            }
            if (name.equals("connection-impl-class")) {
                bean = new StringBean(node, this, "connection-impl-class");
                connectionImplClass.add((StringBean)bean);
                continue;
            }
            if (!name.equals("config-property")) continue;
            bean = new ConfigPropertyBean(node, this);
            configProperty.add((StringBean)bean);
        }
        this.recordXpathForBeans("managedconnectionfactory-class", managedConnectionFactoryClass);
        this.recordXpathForBeans("connectionfactory-interface", connectionFactoryInterface);
        this.recordXpathForBeans("connectionfactory-impl-class", connectionFactoryImplClass);
        this.recordXpathForBeans("connection-interface", connectionInterface);
        this.recordXpathForBeans("connection-impl-class", connectionImplClass);
        this.recordXpathForBeans("config-property", configProperty);
    }
}

