/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.xml;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.DDBeanRoot;
import javax.enterprise.deploy.model.DeployableObject;
import oracle.oc4j.admin.deploy.model.file.J2eeFile;
import oracle.oc4j.admin.deploy.model.xml.AssemblyDescriptorBean;
import oracle.oc4j.admin.deploy.model.xml.BeanNode;
import oracle.oc4j.admin.deploy.model.xml.CollectionJTreeNode;
import oracle.oc4j.admin.deploy.model.xml.EnterpriseBeansBean;
import oracle.oc4j.admin.deploy.model.xml.RelationshipsBean;
import oracle.oc4j.admin.deploy.model.xml.StringBean;
import oracle.oc4j.admin.deploy.model.xml.WSStdXml;
import oracle.oc4j.admin.deploy.model.xml.WebServicesBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EjbModuleBean
extends BeanNode {
    protected String _ejbUri;

    public EjbModuleBean(Node node, DDBean parent) {
        super(node, parent);
        this.init(node);
    }

    public String getDisplayName() {
        return this.nodeValue("display-name");
    }

    public String getDescription() {
        return this.nodeValue("description");
    }

    public String getSmallIcon() {
        return this.nodeValue("small-icon");
    }

    public String getLargeIcon() {
        return this.nodeValue("large-icon");
    }

    public String getEjbClientJar() {
        return this.nodeValue("ejb-client-jar");
    }

    public String getURI() {
        return this._ejbUri;
    }

    public void setURI(String ejbUri) {
        this._ejbUri = ejbUri;
    }

    protected Collection createSpecialJTreeChildren() {
        DDBean[] beans;
        WSStdXml webServicesNode;
        DDBeanRoot myRoot;
        DeployableObject myJarFile;
        Vector<Object> vec = new Vector<Object>();
        String childPath = "relationships";
        DDBean[] relationships = this.getChildBean(childPath);
        if (relationships != null && relationships.length > 0) {
            vec.add(relationships[0]);
        }
        childPath = "assembly-descriptor/security-role";
        CollectionJTreeNode node = new CollectionJTreeNode(this, childPath, "Security Roles", true);
        vec.add(node);
        childPath = "assembly-descriptor/method-permission";
        node = new CollectionJTreeNode(this, childPath, "Method Permissions", true);
        vec.add(node);
        childPath = "assembly-descriptor/container-transaction";
        node = new CollectionJTreeNode(this, childPath, "Container Transactions", true);
        vec.add(node);
        childPath = "assembly-descriptor/message-destination";
        node = new CollectionJTreeNode(this, childPath, "Message Destinations", true);
        vec.add(node);
        childPath = "assembly-descriptor/exclude-list";
        DDBean[] excludeList = this.getChildBean(childPath);
        if (excludeList != null && excludeList.length > 0) {
            vec.add(excludeList[0]);
        }
        if ((myJarFile = (myRoot = this.getRoot()).getDeployableObject()) instanceof J2eeFile && (webServicesNode = (WSStdXml)((J2eeFile)myJarFile).getWSStdXml()) != null) {
            WebServicesBean webServicesBean = (WebServicesBean)webServicesNode.getChildBean("/webservices")[0];
            if (webServicesNode != null) {
                vec.add(webServicesBean);
            }
        }
        if ((beans = this.getChildBean("enterprise-beans/session")) != null) {
            for (int j = 0; j < beans.length; ++j) {
                vec.add(beans[j]);
            }
        }
        if ((beans = this.getChildBean("enterprise-beans/entity")) != null) {
            for (int j = 0; j < beans.length; ++j) {
                vec.add(beans[j]);
            }
        }
        if ((beans = this.getChildBean("enterprise-beans/message-driven")) != null) {
            for (int j = 0; j < beans.length; ++j) {
                vec.add(beans[j]);
            }
        }
        return vec;
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        out.println(indentation + "<" + "ejb-jar" + ">");
        EjbModuleBean.writeAll(this.getChildBean("description"), out, indentation + "\t");
        EjbModuleBean.writeAll(this.getChildBean("display-name"), out, indentation + "\t");
        EjbModuleBean.writeAll(this.getChildBean("small-icon"), out, indentation + "\t");
        EjbModuleBean.writeAll(this.getChildBean("large-icon"), out, indentation + "\t");
        EjbModuleBean.writeAll(this.getChildBean("enterprise-beans"), out, indentation + "\t");
        EjbModuleBean.writeAll(this.getChildBean("relationships"), out, indentation + "\t");
        EjbModuleBean.writeAll(this.getChildBean("assembly-descriptor"), out, indentation + "\t");
        EjbModuleBean.writeAll(this.getChildBean("ejb-client-jar"), out, indentation + "\t");
        out.println(indentation + "</" + "ejb-jar" + ">");
    }

    public String jtreeToolTip() {
        return "EJB Module";
    }

    public String toString() {
        String val = this.getDisplayName();
        if (val == null || val.equals("")) {
            val = this.getURI();
        }
        return val;
    }

    private void init(Node rootNode) {
        this.setXpath("ejb-jar");
        Vector<StringBean> description = new Vector<StringBean>(1);
        Vector<StringBean> displayName = new Vector<StringBean>(1);
        Vector<StringBean> smallIcon = new Vector<StringBean>(1);
        Vector<StringBean> largeIcon = new Vector<StringBean>(1);
        Vector<StringBean> enterpriseBeans = new Vector<StringBean>(1);
        Vector<StringBean> relationships = new Vector<StringBean>(1);
        Vector<StringBean> assemblyDescriptor = new Vector<StringBean>(1);
        Vector<StringBean> ejbClientJar = new Vector<StringBean>(1);
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            BeanNode bean;
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("description")) {
                bean = new StringBean(node, this, "description");
                description.add((StringBean)bean);
            }
            if (name.equals("display-name")) {
                bean = new StringBean(node, this, "display-name");
                displayName.add((StringBean)bean);
            }
            if (name.equals("small-icon")) {
                bean = new StringBean(node, this, "small-icon");
                smallIcon.add((StringBean)bean);
            }
            if (name.equals("large-icon")) {
                bean = new StringBean(node, this, "large-icon");
                largeIcon.add((StringBean)bean);
            }
            if (name.equals("enterprise-beans")) {
                bean = new EnterpriseBeansBean(node, this);
                enterpriseBeans.add((StringBean)bean);
            }
            if (name.equals("relationships")) {
                bean = new RelationshipsBean(node, this);
                relationships.add((StringBean)bean);
            }
            if (name.equals("assembly-descriptor")) {
                bean = new AssemblyDescriptorBean(node, this);
                assemblyDescriptor.add((StringBean)bean);
            }
            if (!name.equals("ejb-client-jar")) continue;
            bean = new StringBean(node, this, "ejb-client-jar");
            ejbClientJar.add((StringBean)bean);
        }
        this.recordXpathForBeans("description", description);
        this.recordXpathForBeans("display-name", displayName);
        this.recordXpathForBeans("small-icon", smallIcon);
        this.recordXpathForBeans("large-icon", largeIcon);
        this.recordXpathForBeans("enterprise-beans", enterpriseBeans);
        this.recordXpathForBeans("assembly-descriptor", assemblyDescriptor);
        this.recordXpathForBeans("relationships", relationships);
        this.recordXpathForBeans("ejb-client-jar", ejbClientJar);
    }
}

