/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.xml;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import oracle.oc4j.admin.deploy.model.xml.BeanNode;
import oracle.oc4j.admin.deploy.model.xml.CollectionJTreeNode;
import oracle.oc4j.admin.deploy.model.xml.MethodParamsBean;
import oracle.oc4j.admin.deploy.model.xml.StringBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MethodBean
extends BeanNode {
    public MethodBean(Node node, DDBean parent) {
        super(node, parent);
        this.init(node);
    }

    public String getDescription() {
        return this.nodeValue("description");
    }

    public String getEjbName() {
        return this.nodeValue("ejb-name");
    }

    public String getMethodIntf() {
        return this.nodeValue("method-intf");
    }

    public String getMethodName() {
        return this.nodeValue("method-name");
    }

    protected Collection createSpecialJTreeChildren() {
        MethodParamsBean methods;
        Vector<CollectionJTreeNode> vec = new Vector<CollectionJTreeNode>();
        DDBean[] methodParamBeans = this.getChildBean("method-params");
        if (methodParamBeans != null && methodParamBeans.length > 0 && methodParamBeans[0] != null && (methods = (MethodParamsBean)methodParamBeans[0]) != null) {
            String childPath = "method-params/method-param";
            CollectionJTreeNode node = new CollectionJTreeNode(this, childPath, "Params", false);
            vec.add(node);
        }
        return vec;
    }

    public String toString() {
        return "Method";
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        out.println(indentation + "<" + "method" + ">");
        MethodBean.writeAll(this.getChildBean("description"), out, indentation + "\t");
        MethodBean.writeAll(this.getChildBean("ejb-name"), out, indentation + "\t");
        MethodBean.writeAll(this.getChildBean("method-intf"), out, indentation + "\t");
        MethodBean.writeAll(this.getChildBean("method-name"), out, indentation + "\t");
        MethodBean.writeAll(this.getChildBean("method-params"), out, indentation + "\t");
        out.println(indentation + "</" + "method" + ">");
    }

    private void init(Node rootNode) {
        this.setXpath("method");
        Vector<StringBean> description = new Vector<StringBean>(1);
        Vector<StringBean> ejbName = new Vector<StringBean>(1);
        Vector<StringBean> methodIntf = new Vector<StringBean>(1);
        Vector<StringBean> methodName = new Vector<StringBean>(1);
        Vector<StringBean> methodParams = new Vector<StringBean>(1);
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            BeanNode bean;
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("description")) {
                bean = new StringBean(node, this, "description");
                description.add((StringBean)bean);
            }
            if (name.equals("ejb-name")) {
                bean = new StringBean(node, this, "ejb-name");
                ejbName.add((StringBean)bean);
            }
            if (name.equals("method-intf")) {
                bean = new StringBean(node, this, "method-intf");
                methodIntf.add((StringBean)bean);
            }
            if (name.equals("method-name")) {
                bean = new StringBean(node, this, "method-name");
                methodName.add((StringBean)bean);
            }
            if (!name.equals("method-params")) continue;
            bean = new MethodParamsBean(node, this);
            methodParams.add((StringBean)bean);
        }
        this.recordXpathForBeans("description", description);
        this.recordXpathForBeans("ejb-name", ejbName);
        this.recordXpathForBeans("method-intf", methodIntf);
        this.recordXpathForBeans("method-name", methodName);
        this.recordXpathForBeans("method-params", methodParams);
    }
}

