/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.xml;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import oracle.oc4j.admin.deploy.model.xml.BeanNode;
import oracle.oc4j.admin.deploy.model.xml.CollectionJTreeNode;
import oracle.oc4j.admin.deploy.model.xml.MethodParamsBean;
import oracle.oc4j.admin.deploy.model.xml.StringBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class QueryMethodBean
extends BeanNode {
    public QueryMethodBean(Node node, DDBean parent) {
        super(node, parent);
        this.init(node);
    }

    public String getMethodName() {
        return this.nodeValue("method-name");
    }

    protected Collection createSpecialJTreeChildren() {
        MethodParamsBean methods;
        Vector<CollectionJTreeNode> vec = new Vector<CollectionJTreeNode>();
        DDBean[] methodParamBeans = this.getChildBean("method-params");
        if (methodParamBeans != null && methodParamBeans.length > 0 && methodParamBeans[0] != null && (methods = (MethodParamsBean)methodParamBeans[0]) != null) {
            String childPath = "method-params/method-param";
            CollectionJTreeNode node = new CollectionJTreeNode(this, childPath, "Params", false);
            vec.add(node);
        }
        return vec;
    }

    public String toString() {
        return "Query Method";
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        out.println(indentation + "<" + "query-method" + ">");
        QueryMethodBean.writeAll(this.getChildBean("method-name"), out, indentation + "\t");
        QueryMethodBean.writeAll(this.getChildBean("method-params"), out, indentation + "\t");
        out.println(indentation + "</" + "query-method" + ">");
    }

    private void init(Node rootNode) {
        this.setXpath("query-method");
        Vector<StringBean> methodName = new Vector<StringBean>(1);
        Vector<StringBean> methodParams = new Vector<StringBean>(1);
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            BeanNode bean;
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("method-name")) {
                bean = new StringBean(node, this, "method-name");
                methodName.add((StringBean)bean);
            }
            if (!name.equals("method-params")) continue;
            bean = new MethodParamsBean(node, this);
            methodParams.add((StringBean)bean);
        }
        this.recordXpathForBeans("method-name", methodName);
        this.recordXpathForBeans("method-params", methodParams);
    }
}

