/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import oracle.oc4j.admin.deploy.model.xml.BeanNode;
import oracle.oc4j.admin.deploy.model.xml.StringBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResourceRefBean
extends BeanNode {
    public ResourceRefBean(Node node, DDBean parent) {
        super(node, parent);
        this.init(node);
    }

    public String getDescription() {
        return this.nodeValue("description");
    }

    public String getResRefName() {
        return this.nodeValue("res-ref-name");
    }

    public String getResType() {
        return this.nodeValue("res-type");
    }

    public String getResAuth() {
        return this.nodeValue("res-auth");
    }

    public String getResSharingScope() {
        return this.nodeValue("res-sharing-scope");
    }

    public String jtreeToolTip() {
        return "Resource Reference";
    }

    public String toString() {
        return this.getResRefName();
    }

    protected boolean leaf() {
        return true;
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        out.println(indentation + "<" + "resource-ref" + ">");
        ResourceRefBean.writeAll(this.getChildBean("description"), out, indentation + "\t");
        ResourceRefBean.writeAll(this.getChildBean("res-ref-name"), out, indentation + "\t");
        ResourceRefBean.writeAll(this.getChildBean("res-type"), out, indentation + "\t");
        ResourceRefBean.writeAll(this.getChildBean("res-auth"), out, indentation + "\t");
        ResourceRefBean.writeAll(this.getChildBean("res-sharing-scope"), out, indentation + "\t");
        out.println(indentation + "</" + "resource-ref" + ">");
    }

    private void init(Node rootNode) {
        this.setXpath("resource-ref");
        Vector<StringBean> description = new Vector<StringBean>(1);
        Vector<StringBean> resRefName = new Vector<StringBean>(1);
        Vector<StringBean> resType = new Vector<StringBean>(1);
        Vector<StringBean> resAuth = new Vector<StringBean>(1);
        Vector<StringBean> resSharingScope = new Vector<StringBean>(1);
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            StringBean bean;
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("description")) {
                bean = new StringBean(node, this, "description");
                description.add(bean);
            }
            if (name.equals("res-ref-name")) {
                bean = new StringBean(node, this, "res-ref-name");
                resRefName.add(bean);
            }
            if (name.equals("res-type")) {
                bean = new StringBean(node, this, "res-type");
                resType.add(bean);
            }
            if (name.equals("res-auth")) {
                bean = new StringBean(node, this, "res-auth");
                resAuth.add(bean);
            }
            if (!name.equals("res-sharing-scope")) continue;
            bean = new StringBean(node, this, "res-sharing-scope");
            resSharingScope.add(bean);
        }
        this.recordXpathForBeans("description", description);
        this.recordXpathForBeans("res-ref-name", resRefName);
        this.recordXpathForBeans("res-type", resType);
        this.recordXpathForBeans("res-auth", resAuth);
        this.recordXpathForBeans("res-sharing-scope", resSharingScope);
    }
}

