/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import oracle.oc4j.admin.deploy.model.xml.BeanNode;
import oracle.oc4j.admin.deploy.model.xml.StringBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SecurityPermissionBean
extends BeanNode {
    String enabled = null;

    public SecurityPermissionBean(Node node, DDBean parent) {
        super(node, parent);
        this.init(node);
    }

    public String getDescription() {
        return this.nodeValue("description");
    }

    public String getSecurityPermissionSpec() {
        return this.nodeValue("security-permission-spec");
    }

    protected boolean leaf() {
        return true;
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "security-permission");
        if (this.enabled != null) {
            XMLUtils.writeAttribute(out, indentation, "enabled", this.enabled);
        }
        XMLUtils.writeTagAttributeEnd(out, indentation, "security-permission");
        SecurityPermissionBean.writeAll(this.getChildBean("description"), out, indentation + "\t");
        SecurityPermissionBean.writeAll(this.getChildBean("security-permission-spec"), out, indentation + "\t");
        XMLUtils.writeTagEnd(out, indentation, "security-permission");
    }

    public String toString() {
        return "Security Permission";
    }

    private void init(Node rootNode) {
        this.setXpath("security-permission");
        Vector<StringBean> description = new Vector<StringBean>(1);
        Vector<StringBean> securityPermissionSpec = new Vector<StringBean>(1);
        this.enabled = XMLUtils.getAttribute(rootNode, "enabled");
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            StringBean bean;
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("description")) {
                bean = new StringBean(node, this, "description");
                description.add(bean);
                continue;
            }
            if (!name.equals("security-permission-spec")) continue;
            bean = new StringBean(node, this, "security-permission-spec");
            securityPermissionSpec.add(bean);
        }
        this.recordXpathForBeans("description", description);
        this.recordXpathForBeans("security-permission-spec", securityPermissionSpec);
    }
}

