/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import oracle.oc4j.admin.deploy.model.xml.BeanNode;
import oracle.oc4j.admin.deploy.model.xml.StringBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SoapHeaderBean
extends BeanNode {
    public SoapHeaderBean(Node node, DDBean parent) {
        super(node, parent);
        this.init(node);
    }

    public String getNamespaceURI() {
        return this.nodeValue("namespaceURI");
    }

    public String getLocalpart() {
        return this.nodeValue("localpart");
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        out.println(indentation + "<" + "soap-header" + ">");
        SoapHeaderBean.writeAll(this.getChildBean("namespaceURI"), out, indentation + "\t");
        SoapHeaderBean.writeAll(this.getChildBean("localpart"), out, indentation + "\t");
        out.println(indentation + "</" + "soap-header" + ">");
    }

    public String jtreeToolTip() {
        return "Wsdl Port";
    }

    public String toString() {
        return this.getNamespaceURI();
    }

    private void init(Node rootNode) {
        this.setXpath("soap-header");
        Vector<StringBean> namespaceURI = new Vector<StringBean>(1);
        Vector<StringBean> localpart = new Vector<StringBean>(1);
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            StringBean bean;
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("namespaceURI")) {
                bean = new StringBean(node, this, "namespaceURI");
                namespaceURI.add(bean);
            }
            if (!name.equals("localpart")) continue;
            bean = new StringBean(node, this, "localpart");
            localpart.add(bean);
        }
        this.recordXpathForBeans("namespaceURI", namespaceURI);
        this.recordXpathForBeans("localpart", localpart);
    }
}

