/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.xml;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import oracle.oc4j.admin.deploy.model.xml.BeanNode;
import oracle.oc4j.admin.deploy.model.xml.IconBean;
import oracle.oc4j.admin.deploy.model.xml.PortComponentBean;
import oracle.oc4j.admin.deploy.model.xml.StringBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WebServiceDescriptionBean
extends BeanNode {
    public WebServiceDescriptionBean(Node node, DDBean parent) {
        super(node, parent);
        this.init(node);
    }

    public String getDisplayName() {
        return this.nodeValue("display-name");
    }

    public String getDescription() {
        return this.nodeValue("description");
    }

    public String getSmallIcon() {
        return this.nodeValue("icon/small-icon");
    }

    public String getLargeIcon() {
        return this.nodeValue("icon/large-icon");
    }

    public String getWebserviceDescriptionName() {
        return this.nodeValue("webservice-description-name");
    }

    public String getWsdlFile() {
        return this.nodeValue("wsdl-file");
    }

    public String getJaxrpcMappingFile() {
        return this.nodeValue("jaxrpc-mapping-file");
    }

    protected Collection createSpecialJTreeChildren() {
        Vector<DDBean> vec = new Vector<DDBean>();
        String childPath = "port-component";
        DDBean[] beans = this.getChildBean(childPath);
        if (beans != null) {
            for (int j = 0; j < beans.length; ++j) {
                vec.add(beans[j]);
            }
        }
        return vec;
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        out.println(indentation + "<" + "webservice-description" + ">");
        WebServiceDescriptionBean.writeAll(this.getChildBean("description"), out, indentation + "\t");
        WebServiceDescriptionBean.writeAll(this.getChildBean("display-name"), out, indentation + "\t");
        WebServiceDescriptionBean.writeAll(this.getChildBean("icon"), out, indentation + "\t");
        WebServiceDescriptionBean.writeAll(this.getChildBean("webservice-description-name"), out, indentation + "\t");
        WebServiceDescriptionBean.writeAll(this.getChildBean("wsdl-file"), out, indentation + "\t");
        WebServiceDescriptionBean.writeAll(this.getChildBean("jaxrpc-mapping-file"), out, indentation + "\t");
        out.println(indentation + "</" + "webservice-description" + ">");
    }

    public String jtreeToolTip() {
        return "Web Service Description";
    }

    public String toString() {
        String ret = this.getDisplayName();
        if (ret != null && ret.length() > 0) {
            return ret;
        }
        return "Web Service Description";
    }

    private void init(Node rootNode) {
        this.setXpath("webservice-description");
        Vector<IconBean> icon = new Vector<IconBean>(1);
        Vector<IconBean> displayName = new Vector<IconBean>(1);
        Vector<IconBean> description = new Vector<IconBean>(1);
        Vector<IconBean> webServiceDescName = new Vector<IconBean>(1);
        Vector<IconBean> wsdlFile = new Vector<IconBean>(1);
        Vector<IconBean> jaxrpcMappingFile = new Vector<IconBean>(1);
        Vector<IconBean> portComponent = new Vector<IconBean>(1);
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            BeanNode bean;
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("icon")) {
                bean = new IconBean(node, this);
                icon.add((IconBean)bean);
            }
            if (name.equals("display-name")) {
                bean = new StringBean(node, this, "display-name");
                displayName.add((IconBean)bean);
            }
            if (name.equals("description")) {
                bean = new StringBean(node, this, "description");
                description.add((IconBean)bean);
            }
            if (name.equals("webservice-description-name")) {
                bean = new StringBean(node, this, "webservice-description-name");
                webServiceDescName.add((IconBean)bean);
            }
            if (name.equals("wsdl-file")) {
                bean = new StringBean(node, this, "wsdl-file");
                wsdlFile.add((IconBean)bean);
            }
            if (name.equals("jaxrpc-mapping-file")) {
                bean = new StringBean(node, this, "jaxrpc-mapping-file");
                jaxrpcMappingFile.add((IconBean)bean);
            }
            if (!name.equals("port-component")) continue;
            bean = new PortComponentBean(node, this);
            portComponent.add((IconBean)bean);
        }
        this.recordXpathForBeans("icon", icon);
        this.recordXpathForBeans("display-name", displayName);
        this.recordXpathForBeans("description", description);
        this.recordXpathForBeans("webservice-description-name", webServiceDescName);
        this.recordXpathForBeans("wsdl-file", wsdlFile);
        this.recordXpathForBeans("jaxrpc-mapping-file", jaxrpcMappingFile);
        this.recordXpathForBeans("port-component", portComponent);
    }
}

