/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.shared.util;

import java.io.CharArrayWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.StringTokenizer;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;

public class File
extends java.io.File {
    public File(File parent, String child) throws NullPointerException {
        super(parent, child);
    }

    public File(String pathname) throws NullPointerException {
        super(pathname);
    }

    public File(String parent, String child) throws NullPointerException {
        super(parent, child);
    }

    public final void recursiveRemove() throws IOException {
        File.recursiveRemove(this);
    }

    public final void copyTo(java.io.File toDir) throws FileNotFoundException, Exception {
        this.copyTo(toDir, false);
    }

    public final void copyTo(java.io.File toDir, boolean readOnly) throws FileNotFoundException, Exception {
        File.copyFile(this, toDir, readOnly);
    }

    public final void copyToFile(java.io.File targetFile) throws FileNotFoundException, Exception {
        File.copyFile(this, targetFile, false, true);
    }

    public final void copyToFile(java.io.File targetFile, boolean readOnly) throws FileNotFoundException, Exception {
        File.copyFile(this, targetFile, readOnly, true);
    }

    public static File createTempDir(java.io.File targetDir) throws IOException, FileNotFoundException, IllegalArgumentException, SecurityException {
        return File.createTempDir("tmp", "", targetDir);
    }

    public static File createTempDir(String prefix, java.io.File targetDir) throws IOException, FileNotFoundException, IllegalArgumentException, SecurityException {
        return File.createTempDir(prefix, "", targetDir);
    }

    public static File createTempDir(String prefix, String suffix, java.io.File targetDir) throws IOException, FileNotFoundException, IllegalArgumentException, SecurityException {
        if (!targetDir.exists()) {
            throw new FileNotFoundException(FormattingResourceBundle.DeploymentMessages.getString("noDirectory", new String[]{targetDir.getName()}));
        }
        if (!targetDir.isDirectory()) {
            throw new IOException(FormattingResourceBundle.DeploymentMessages.getString("notADirectory", new String[]{targetDir.getName()}));
        }
        if (suffix == null) {
            suffix = "";
        }
        File temp = new File(java.io.File.createTempFile(prefix, suffix, targetDir).getAbsolutePath());
        temp.delete();
        if (!temp.mkdir()) {
            throw new IOException(FormattingResourceBundle.DeploymentMessages.getString("createDirectoryFailed", new String[]{temp.getName()}));
        }
        return temp;
    }

    public static void recursiveRemove(java.io.File file) throws IOException {
        if (file != null && file.exists()) {
            if (file.isDirectory()) {
                java.io.File[] files = file.listFiles();
                for (int i = 0; files != null && i < files.length; ++i) {
                    if (files[i].isDirectory()) {
                        File.recursiveRemove(files[i]);
                        continue;
                    }
                    if (files[i].delete()) continue;
                    throw new IOException(FormattingResourceBundle.DeploymentMessages.getString("deleteFileFailure", new String[]{files[i].getName()}));
                }
            }
            if (!file.delete()) {
                throw new IOException(FormattingResourceBundle.DeploymentMessages.getString("deleteFileFailure", new String[]{file.getName()}));
            }
        }
    }

    public static void copyFile(java.io.File file, java.io.File toDir) throws FileNotFoundException, Exception {
        File.copyFile(file, toDir, false);
    }

    public static void copyFile(java.io.File file, java.io.File toDir, boolean readOnly) throws FileNotFoundException, Exception {
        File.copyFile(file, toDir, readOnly, false);
    }

    public static void copyFile(java.io.File file, java.io.File toDir, boolean readOnly, boolean isDestFile) throws FileNotFoundException, Exception {
        if (!file.exists()) {
            throw new FileNotFoundException(FormattingResourceBundle.DeploymentMessages.getString("noFile", new String[]{file.getName()}));
        }
        if (!isDestFile && !toDir.exists()) {
            throw new FileNotFoundException(FormattingResourceBundle.DeploymentMessages.getString("noDirectory", new String[]{toDir.getName()}));
        }
        if (!isDestFile && toDir.exists() && !toDir.isDirectory()) {
            throw new IOException(FormattingResourceBundle.DeploymentMessages.getString("notADirectory", new String[]{toDir.getName()}));
        }
        if (isDestFile && toDir.exists()) {
            throw new IOException(FormattingResourceBundle.DeploymentMessages.getString("fileExists", new String[]{toDir.getName()}));
        }
        if (isDestFile && (toDir.getParentFile() == null || !toDir.getParentFile().exists())) {
            throw new IOException(FormattingResourceBundle.DeploymentMessages.getString("noDirectory", new String[]{toDir.getParentFile().getName()}));
        }
        FileInputStream fin = null;
        FileOutputStream fout = null;
        try {
            int read;
            fin = new FileInputStream(file);
            java.io.File destFile = null;
            destFile = !isDestFile ? new java.io.File(toDir, file.getName()) : toDir;
            fout = new FileOutputStream(destFile);
            byte[] bytes = new byte[512];
            while ((read = fin.read(bytes)) != -1) {
                fout.write(bytes, 0, read);
            }
            fin.close();
            fin = null;
            fout.close();
            if (readOnly) {
                destFile.setReadOnly();
            }
        }
        catch (Exception e) {
            if (fin != null) {
                fin.close();
            }
            if (fout != null) {
                fout.close();
            }
            throw (Exception)e.fillInStackTrace();
        }
    }

    public boolean createNewFileRecursive() throws IOException {
        String fileName = this.getPath();
        String partialPath = "";
        if (fileName.charAt(0) == '/' || fileName.charAt(0) == '\\') {
            partialPath = partialPath + fileName.charAt(0);
        }
        StringTokenizer st = new StringTokenizer(fileName, "/\\");
        try {
            while (st.hasMoreTokens()) {
                File file = new File(partialPath = partialPath + st.nextToken());
                if (!file.exists()) {
                    if (st.hasMoreTokens()) {
                        if (!file.mkdir()) {
                            return false;
                        }
                    } else {
                        return this.createNewFile();
                    }
                }
                partialPath = partialPath + separator;
            }
        }
        catch (IOException ioe) {
            throw (IOException)ioe.fillInStackTrace();
        }
        return true;
    }

    public static String readFileToString(String fileName) throws IOException {
        FileReader fileReader = new FileReader(fileName);
        return File.toString(fileReader);
    }

    public static void writeStringAsFile(String stringToBeWritten, String fileName) throws IOException {
        FileWriter outStr = new FileWriter(fileName);
        char[] contents = stringToBeWritten.toCharArray();
        outStr.write(contents);
        ((Writer)outStr).flush();
    }

    private static String toString(Reader reader) throws IOException {
        char[] buff = new char[1024];
        CharArrayWriter resultCharStr = new CharArrayWriter();
        if (reader.markSupported()) {
            reader.reset();
        }
        int charsRead = 1;
        while (charsRead != -1) {
            charsRead = reader.read(buff);
            if (charsRead == -1) continue;
            resultCharStr.write(buff, 0, charsRead);
        }
        if (reader.markSupported()) {
            reader.reset();
        }
        return new String(resultCharStr.toCharArray());
    }
}

