/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.shared.xml;

import java.util.StringTokenizer;
import oracle.oc4j.admin.deploy.model.file.J2eeFile;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.shared.xml.J2eeXmlNode;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Element;

public class J2eeXmlDesc
extends J2eeXmlNode {
    private J2eeFile _file;
    private String _entryName;
    private String _publicId;
    private String _DTDVersion = "";
    private String _version;

    public J2eeXmlDesc(XMLDocument doc) {
        this(doc, null, null);
    }

    public J2eeXmlDesc(XMLDocument doc, J2eeFile file, String entryName) {
        super(doc.getDocumentElement());
        if (doc.getDoctype() != null) {
            this._publicId = doc.getDoctype().getPublicId();
            StringTokenizer idTokens = new StringTokenizer(this._publicId, "//");
            if (idTokens.countTokens() > 2) {
                idTokens.nextToken();
                idTokens.nextToken();
                String label = idTokens.nextToken();
                if (label != null) {
                    StringTokenizer labelTokens = new StringTokenizer(label, " ");
                    String labelToken = "";
                    while (labelTokens.hasMoreTokens()) {
                        labelToken = labelTokens.nextToken();
                    }
                    this._DTDVersion = new String(labelToken);
                }
            }
        } else {
            Element root = doc.getDocumentElement();
            if (root != null) {
                this._DTDVersion = XMLUtils.getAttribute(root, "version");
                String majorVersion = XMLUtils.getAttribute(root, "schema-major-version");
                String minorVersion = XMLUtils.getAttribute(root, "schema-minor-version");
                if (majorVersion != null) {
                    this._version = minorVersion != null ? majorVersion + "." + minorVersion : majorVersion;
                }
            }
        }
        this._file = file;
        this._entryName = entryName;
    }

    public J2eeFile getFile() {
        return this._file;
    }

    public String getEntryName() {
        return this._entryName;
    }

    public String getModuleDTDVersion() {
        return this._DTDVersion;
    }

    public String getVersion() {
        return this._version;
    }
}

