/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.shell;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.StringTokenizer;
import oracle.oc4j.admin.deploy.shell.AdminShell;
import oracle.oc4j.admin.deploy.shell.CARDeployer;
import oracle.oc4j.admin.deploy.shell.DeployerImpl;
import oracle.oc4j.admin.deploy.shell.EARDeployer;
import oracle.oc4j.admin.deploy.shell.EJBDeployer;
import oracle.oc4j.admin.deploy.shell.InstanceManagerImpl;
import oracle.oc4j.admin.deploy.shell.RARDeployer;
import oracle.oc4j.admin.deploy.shell.WARDeployer;

class ShellHandler {
    private final int HISTORYLISTSIZE = 30;
    private final int EVENTLISTSIZE = 255;
    private int[] historyList = new int[30];
    private String[] eventList = new String[255];
    final int BUFSIZE = 4096;
    final String COMMENT = "#";
    final String CMD_EXIT = "Exit";
    final String CMD_REPEATCOMMAND = "!!";
    final String CMD_REPEATRAMDON = "!";
    int m_eventListPointer = 0;
    int m_historyListPointer = 0;
    String input = null;

    ShellHandler() {
    }

    void handleShellCommand(List arguments) {
        int i;
        int nextByte = 0;
        byte[] buf = new byte[4096];
        for (i = 0; i < 255; ++i) {
            this.eventList[i] = null;
        }
        for (i = 0; i < 30; ++i) {
            this.historyList[i] = 254;
        }
        InputStream s_input = null;
        if (arguments.isEmpty()) {
            s_input = System.in;
        } else {
            try {
                String fileOption = AdminShell.getNextArgumentFromCommandLine(arguments, "-file option");
                s_input = "-f".equals(fileOption) ? new FileInputStream(AdminShell.getNextArgumentFromCommandLine(arguments, "filename")) : System.in;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        while (true) {
            try {
                while (true) {
                    int cnt = 0;
                    System.out.print("\nAdmin > ");
                    for (cnt = 0; cnt < 4096 && (nextByte = s_input.read()) != -1 && (char)nextByte != '\n'; ++cnt) {
                        buf[cnt] = (byte)nextByte;
                    }
                    if (nextByte == -1) {
                        this.input = "Exit";
                    } else {
                        this.input = new String(buf, 0, cnt);
                        if (this.input.trim().startsWith("!!") ? !this.findLastCommand() : (this.input.startsWith("!") ? !this.findCommandFromHistory() : this.input.startsWith("#"))) continue;
                        this.updateHistoryList();
                    }
                    this.execute(arguments);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private boolean findCommandFromHistory() {
        int eventNum;
        boolean found = false;
        int idx = this.input.indexOf("!");
        idx += "!".length();
        try {
            eventNum = new Integer(this.input.substring(idx));
        }
        catch (NumberFormatException e) {
            System.out.println(this.input.substring(idx) + ": Event not found.");
            return false;
        }
        for (int i = 0; i < 30; ++i) {
            if (this.historyList[i] != eventNum) continue;
            found = true;
            break;
        }
        if (!found) {
            System.out.println(eventNum + ": Event not found.");
            return false;
        }
        this.input = this.eventList[eventNum];
        System.out.println(this.input);
        return true;
    }

    private boolean findLastCommand() {
        if (this.m_historyListPointer != 0) {
            this.input = this.eventList[this.historyList[--this.m_historyListPointer]];
            ++this.m_historyListPointer;
        } else {
            return false;
        }
        System.out.println(this.input);
        return true;
    }

    private void updateHistoryList() {
        if (this.m_historyListPointer == 30) {
            for (int i = 0; i < 29; ++i) {
                this.historyList[i] = this.historyList[i + 1];
            }
            --this.m_historyListPointer;
        }
        if (this.m_eventListPointer > 254) {
            this.m_eventListPointer = 0;
        }
        this.historyList[this.m_historyListPointer] = this.m_eventListPointer;
        this.eventList[this.m_eventListPointer] = this.input;
        ++this.m_historyListPointer;
        ++this.m_eventListPointer;
    }

    private void execute(List arguments) {
        String command;
        StringTokenizer st = new StringTokenizer(this.input);
        int len = st.countTokens();
        if (len != 0) {
            arguments.clear();
            String[] options = new String[len];
            for (int i = 0; i < len; ++i) {
                options[i] = st.nextToken();
            }
            command = options[0];
            for (int i = 1; i < len; ++i) {
                arguments.add(options[i]);
            }
        } else {
            return;
        }
        this.executeCommand(command, arguments);
    }

    private void executeCommand(String command, List arguments) {
        block42: {
            String CMD_SHUTDOWN = "shutdown";
            String CMD_RESTART = "restart";
            String CMD_DEPLOYEAR = "deployear";
            String CMD_DEPLOYWAR = "deploywar";
            String CMD_DEPLOYEJB = "deployejb";
            String CMD_DEPLOYCAR = "deploycar";
            String CMD_DEPLOYRAR = "deployrar";
            String CMD_UNDEPLOY = "undeploy";
            String CMD_BINDWEBMODULE = "bindWebModule";
            String CMD_BINDAPP = "bindApp";
            String CMD_LISTAPPS = "list";
            String CMD_HISTORY = "history";
            String CMD_HELP = "help";
            String CMD_EXIT = "exit";
            if (command == null) {
                return;
            }
            try {
                if (command.equalsIgnoreCase(CMD_SHUTDOWN)) {
                    InstanceManagerImpl instanceManager = new InstanceManagerImpl();
                    try {
                        instanceManager.shutdown();
                        break block42;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return;
                    }
                }
                if (command.equalsIgnoreCase(CMD_RESTART)) {
                    InstanceManagerImpl instanceManager = new InstanceManagerImpl();
                    try {
                        instanceManager.restart();
                        break block42;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return;
                    }
                }
                if (command.equalsIgnoreCase(CMD_DEPLOYEAR)) {
                    EARDeployer earDeployer = new EARDeployer();
                    try {
                        earDeployer.handleDeployment(arguments);
                        break block42;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return;
                    }
                }
                if (command.equalsIgnoreCase(CMD_DEPLOYWAR)) {
                    WARDeployer warDeployer = new WARDeployer();
                    try {
                        warDeployer.handleDeployment(arguments);
                        break block42;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return;
                    }
                }
                if (command.equalsIgnoreCase(CMD_DEPLOYEJB)) {
                    EJBDeployer ejbDeployer = new EJBDeployer();
                    try {
                        ejbDeployer.handleDeployment(arguments);
                        break block42;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return;
                    }
                }
                if (command.equalsIgnoreCase(CMD_DEPLOYCAR)) {
                    CARDeployer carDeployer = new CARDeployer();
                    try {
                        carDeployer.handleDeployment(arguments);
                        break block42;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return;
                    }
                }
                if (command.equalsIgnoreCase(CMD_DEPLOYRAR)) {
                    RARDeployer rarDeployer = new RARDeployer();
                    try {
                        rarDeployer.handleDeployment(arguments);
                        break block42;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return;
                    }
                }
                if (command.equalsIgnoreCase(CMD_UNDEPLOY)) {
                    DeployerImpl deployerImpl = new DeployerImpl();
                    try {
                        deployerImpl.handleUnDeployment(arguments);
                        break block42;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return;
                    }
                }
                if (command.equalsIgnoreCase(CMD_BINDWEBMODULE)) {
                    DeployerImpl deployerImpl = new DeployerImpl();
                    try {
                        deployerImpl.handleBindWebModule(arguments);
                        break block42;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return;
                    }
                }
                if (command.equalsIgnoreCase(CMD_BINDAPP)) {
                    DeployerImpl deployerImpl = new DeployerImpl();
                    try {
                        deployerImpl.handleBindApp(arguments);
                        break block42;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return;
                    }
                }
                if (command.equalsIgnoreCase(CMD_LISTAPPS)) {
                    InstanceManagerImpl instanceManager = new InstanceManagerImpl();
                    try {
                        instanceManager.handleListApps(arguments);
                        break block42;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return;
                    }
                }
                if (command.equalsIgnoreCase(CMD_HISTORY)) {
                    this.handleHistory(arguments);
                } else if (command.equalsIgnoreCase(CMD_HELP)) {
                    this.handleHelp(arguments);
                } else if (command.equalsIgnoreCase(CMD_EXIT)) {
                    this.handleExit(arguments);
                } else {
                    System.err.println(command + ": not found.");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void handleExit(List arguments) {
        AdminShell.doExit();
    }

    private void handleHistory(List arguments) {
        for (int i = 0; i < 30; ++i) {
            if (this.eventList[this.historyList[i]] == null) continue;
            System.out.println("   " + this.historyList[i] + "   " + this.eventList[this.historyList[i]]);
        }
    }

    private void handleHelp(List arguments) {
        if (arguments.isEmpty()) {
            this.showUsage();
            return;
        }
        String firstArgument = (String)arguments.get(0);
        if (firstArgument.equalsIgnoreCase("shutdown")) {
            this.showShutdownUsage();
            return;
        }
        if (firstArgument.equalsIgnoreCase("restart")) {
            this.showRestartUsage();
            return;
        }
        if (firstArgument.equalsIgnoreCase("deployEar")) {
            this.showDeployUsage();
            return;
        }
        if (firstArgument.equalsIgnoreCase("deployWar")) {
            this.showDeployWarUsage();
            return;
        }
        if (firstArgument.equalsIgnoreCase("deployEjb")) {
            this.showDeployEjbUsage();
            return;
        }
        if (firstArgument.equalsIgnoreCase("deployCar")) {
            this.showDeployCarUsage();
            return;
        }
        if (firstArgument.equalsIgnoreCase("deployRar")) {
            this.showDeployConnectorUsage();
            return;
        }
        if (firstArgument.equalsIgnoreCase("undeploy")) {
            this.showUndeployUsage();
            return;
        }
        if (firstArgument.equalsIgnoreCase("bindWebModule")) {
            this.showBindWebModuleUsage();
            return;
        }
        if (firstArgument.equalsIgnoreCase("bindApp")) {
            this.showBindAppUsage();
            return;
        }
        if (firstArgument.equalsIgnoreCase("list")) {
            this.showListUsage();
            return;
        }
    }

    private void showUsage() {
        System.out.println("Commands are:\n\n    deployEar -file <filename> -deploymentName <appname> [options]\n                        (re)deploys an ear application\n    deployWar -file <filename> -deploymentName <appname> [options]\n                        (re)deploys a web application\n    deployEjb -file <filename> -deploymentName <appname> [options]\n                        (re)deploys an ejb application\n    deployCar -file <filename> -deploymentName <appname> [options]\n                        (re)deploys a Client Application archive\n    deployRar -file <filename> -name <appname> [options]\n                        (re)deploys a Connector resource adapter(RAR)\n    undeploy <appname> [options]\n                        removes a previously deployed application, \n                        including .ear, .war, .jar, .rar, .car files\n    bindWebModule -app <app name> -module <web module name>\n                  -site <web site name> -root <context root>\n                        binds a web module to a web site with a specified\n                        root\n    bindApp -app <app name> -site <web site name>\n                        binds all web modules in an application to a web site\n    list [options]      shows the information of all deployed applications or\n                        modules\n\n    history             displays command history list\n    !!                  repeats the last command\n    ![number]           finds and repeats the specified command\n    help                prints this help message\n    help [command]      prints details on the command\n    exit                exits this command line shell\n\n");
    }

    private void showShutdownUsage() {
        System.out.println("Usage: shutdown [force|ordinary] [reason]\n           - shuts the entire server down\nwhere force    -\n      ordinary -\n      reason   - A string indicates why shuts down the server\n");
    }

    private void showRestartUsage() {
        System.out.println("Usage: restart [reason]\n           - restarts the entire server\nwhere reason   - A string indicates why restarts the server\n");
    }

    private void showDeployUsage() {
        System.out.println("Usage: deployEar -file <filename> -deploymentName <appname> [-bindWebApp <web-site name>]\n       [-parent <name>] [-targetPath <path>] [-deploymentDirectory <path>] [-cluster] [-force]\n\n                          - (re)deploys an ear application. \nwhere:\n\n   -bindWebApp <web-site name>\n                          - Name of the web-site to which web-module's binding will be added.\n                            If this option is not specified, then no binding will be added \n                            as part of deployment.\n   -parent <name>         - Unique name that identify the parent application from which \n                            this application will inherit properties. If this option is not \n                            specified then the ('default') application will be used\n   -targetPath <path>     - The path on the remote OS to place the archive at.\n                            If not specified the ('applications') directory is used\n   -deploymentDirectory <path>\n                          - Root of the deployment configurations,\n                            \"[NONE]\" to place them inside the .ear\n   -cluster               - Signals that the deployment should be propagated to\n                            other live cluster nodes if part of a cluster\n   -force                 - Redeploys this ear application\n");
    }

    private void showDeployWarUsage() {
        System.out.println("Usage: \ndeployWar -file <filename> -deploymentName <appname> [-bindWebApp <web-site name> -contextRoot <root>]\n[-parent <name>] [-targetPath <path>] [-deploymentDirectory <path>] [-cluster] [-force]\n\n                           - (re)deploys a web application.\nwhere\n\n   -bindWebApp <web-site name> -contextRoot <root>\n                          - Name of the web-site to which web-module's binding will be added \n                            with the specified root. If these options are not specified, \n                            then no binding will be added as part of deployment.\n   -parent <name>         - Unique name that identify the parent application from which \n                            this application will inherit properties. If this option is not \n                            specified then the ('default') application will be used\n   -targetPath <path>     - The path on the remote OS to place the archive at.\n                            If not specified the ('applications') directory is used\n   -deploymentDirectory <path>\n                          - Root of the deployment configurations,\n                            \"[NONE]\" to place them inside the .ear\n   -cluster               - Signals that the deployment should be propagated to\n                            other live cluster nodes if part of a cluster\n   -force                 - Redeploy this web application\n");
    }

    private void showDeployEjbUsage() {
        System.out.println("Usage: deployEjb -file <filename> -deploymentName <appname> [-parent <name>] [-targetPath <path>]\n       [-deploymentDirectory <path>] [-cluster] [-force] \n\n                            - (re)deploys an EJB module.\nwhere\n\n   -parent <name>         - Unique name that identify the parent application from which \n                            this application will inherit properties. If this option is not \n                            specified then the ('default') application will be used\n   -targetPath <path>     - The path on the remote OS to place the archive at.\n                            If not specified the ('applications') directory is used\n   -deploymentDirectory <path>\n                          - Root of the deployment configurations,\n                            \"[NONE]\" to place them inside the .ear\n   -cluster               - Signals that the deployment should be propagated to\n                            other live cluster nodes if part of a cluster\n   -force                 - Redeploys this EJB module\n");
    }

    private void showDeployCarUsage() {
        System.out.println("Usage: deployCar -file <filename> -deploymentName <appname> [-parent <name>] [-targetPath <path>]\n       [-deploymentDirectory <path>] [-cluster] [-force] \n\n                            - (re)deploys a Client Application archive (CAR).\nwhere\n\n   -parent <name>         - Unique name that identify the parent application from which \n                            this application will inherit properties. If this option is not \n                            specified then the ('default') application will be used\n   -targetPath <path>     - The path on the remote OS to place the archive at.\n                            If not specified the ('applications') directory is used\n   -deploymentDirectory <path>\n                          - Root of the deployment configurations,\n                            \"[NONE]\" to place them inside the .ear\n   -cluster               - Signals that the deployment should be propagated to\n                            other live cluster nodes if part of a cluster\n   -force                 - Redeploys this Client Application archive\n");
    }

    private void showDeployConnectorUsage() {
        System.out.println("Usage: deployRar -file <filename> -name <appname> [-nativeLibPath <path>] [-grantAllPermissions]\n\n           - deploy a Connector Architecture compliant resource adapter (RAR)\nwhere\n\n   -nativeLibPath <path> - path to the native libraries within the RAR archive\n   -grantAllPermissions  - grant all runtime permissions requested by the RAR\n");
    }

    private void showUndeployUsage() {
        System.out.println("Usage: undeploy <appname> [-keepFiles] [-isConnector] \n           -  remove a previously deployed application\nwhere \n    -keepFiles       - keeps the generated application's files\n    -isConnector     - sets to true if undeploying a Resource Adapter module \n");
    }

    private void showBindWebModuleUsage() {
        System.out.println("Usage: bindWebModule -app <app name> -module <web module name> -site <web site name> \n       -root <context root>\n\n           - binds a web module to a web site with a specified root\nwhere\n\n    -app <app name>            - Unique name that identify the application\n    -module <web module name>  - Unique name that identify the web module in the application\n    -site <web site name>      - Name of the web-site to which web module's binding will be added. \n    -root <context root>       - Context root used for binding\n");
    }

    private void showBindAppUsage() {
        System.out.println("Usage:  bindApp -app <app name> -site <web site name>\n\n            - binds all web modules in an application to a web site\nwhere \n\n    -app <app name>            - Unique name that identify the application\n    -site <web site name>      - Name of the web-site to which web module's binding will be added. \n");
    }

    private void showListUsage() {
        System.out.println("Usage: list [-all |-app [app-name] |-web |-ejb |-appClient |-resource |-JDBCResource <resource-name>]\n           - shows the information of all deployed applications or modules\nwhere \n    - all            - show all of the modules in the oc4j instance, including \n                       applications, EJB modules, web modules, application client modules\n    - app [app-name] - shows all of the applications running in oc4j instance \n                       or the resources and the modules information the particular application has\n                       if app-name is specified\n    - web            - shows all of the web modules running in oc4j instance\n    - ejb            - shows all of the ejb modules running in oc4j instance\n    - appClient      - shows all of the application client modules deployed\n    - resource       - shows all of the resources this oc4j instance has, including \n                       Java Mail resource, JDBC resource, JMS resource, URL resource\n    - JDBCResource resource-name \n                     - shows attributes the JDBC resource associated with resource-name has\n");
    }
}

