/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.DDBeanRoot;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.model.J2eeApplicationObject;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DConfigBeanRoot;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.BeanNotFoundException;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.deploy.gui.TargetModuleNode;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;
import oracle.oc4j.admin.deploy.spi.DeplManager;
import oracle.oc4j.admin.deploy.spi.ProprietaryTargetModuleID;
import oracle.oc4j.admin.deploy.spi.exceptions.ExtendedConfigurationException;
import oracle.oc4j.admin.deploy.spi.exceptions.ExtendedInvalidModuleException;
import oracle.oc4j.admin.deploy.spi.xml.AppType;
import oracle.oc4j.admin.deploy.spi.xml.ApplicationConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.BooleanType;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanRootNode;
import oracle.oc4j.admin.deploy.spi.xml.EarDepXml;
import oracle.oc4j.admin.deploy.spi.xml.JaznConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.JaznLoginConfigType;
import oracle.oc4j.admin.deploy.spi.xml.LoginModuleType;
import oracle.oc4j.admin.deploy.spi.xml.OptionNameType;
import oracle.oc4j.admin.deploy.spi.xml.OptionType;
import oracle.oc4j.admin.deploy.spi.xml.StringType;
import oracle.oc4j.admin.deploy.spi.xml.WarDepXml;
import oracle.oc4j.admin.deploy.spi.xml.WebSiteBindingType;
import oracle.oc4j.admin.deploy.spi.xml.WebSiteType;
import oracle.oc4j.admin.management.shared.WebBinding;
import oracle.oc4j.admin.management.shared.WebSiteBindings;

public class DeplConfiguration
implements DeploymentConfiguration {
    public static final String invalidAppChars = ":\"=,*?";
    private static Logger logger_ = TraceLogger.getLogger((Class)DeplConfiguration.class);
    protected DeployableObject _deployableObject = null;
    protected ConfigBeanRootNode _depXml = null;
    protected ConfigBeanRootNode _WSDepXml = null;
    protected Hashtable _childConf = new Hashtable();
    protected DeplManager _mgr = null;
    protected String _dataSources = null;
    protected String _jaznData = null;

    public DeplConfiguration(DeployableObject obj, DeplManager mgr) throws InvalidModuleException {
        this._deployableObject = obj;
        this._mgr = mgr;
        if (obj.getType().equals(ModuleType.EAR)) {
            try {
                this._depXml = ConfigBeanRootNode.createConf(obj, ".", mgr, null, null);
            }
            catch (Throwable t) {
                throw new ExtendedInvalidModuleException(t);
            }
            J2eeApplicationObject j2eeApplicationObject = (J2eeApplicationObject)obj;
            String[] moduleUris = j2eeApplicationObject.getModuleUris();
            if (moduleUris != null && moduleUris.length > 0) {
                for (int n = 0; n < moduleUris.length; ++n) {
                    DeployableObject moduleObj = j2eeApplicationObject.getDeployableObject(moduleUris[n]);
                    ConfigBeanRootNode depXml = null;
                    ConfigBeanRootNode wsDepXml = null;
                    try {
                        depXml = ConfigBeanRootNode.createConf(moduleObj, moduleUris[n], mgr, this._depXml, null);
                    }
                    catch (Throwable t) {
                        throw new ExtendedInvalidModuleException(t);
                    }
                    this._childConf.put(moduleUris[n], depXml);
                    try {
                        wsDepXml = ConfigBeanRootNode.createWSConf(moduleObj, moduleUris[n] + ":webservices", mgr, this._depXml, depXml, null);
                    }
                    catch (Throwable t) {
                        throw new ExtendedInvalidModuleException(t);
                    }
                    if (wsDepXml == null) continue;
                    this._childConf.put(moduleUris[n] + ":webservices", wsDepXml);
                }
            }
        } else {
            try {
                this._depXml = ConfigBeanRootNode.createConf(obj, ".", mgr, null, null);
                this._WSDepXml = ConfigBeanRootNode.createWSConf(obj, ".:webservices", mgr, null, this._depXml, null);
            }
            catch (Throwable t) {
                throw new ExtendedInvalidModuleException(t);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DeplConfiguration(DeployableObject obj, DeplManager mgr, ProprietaryTargetModuleID tgt) throws InvalidModuleException {
        this._deployableObject = obj;
        this._mgr = mgr;
        if (obj.getType().equals(ModuleType.EAR)) {
            if (tgt.getParentTargetModuleID() != null) {
                throw new ExtendedInvalidModuleException("target module is not a root module");
            }
            String webSiteBinding = null;
            try {
                Vector loginModules;
                String location;
                JaznConfigBean jaznConfigBean;
                String dsPath;
                this._depXml = ConfigBeanRootNode.createConf(obj, ".", mgr, null, tgt.getProprietaryDeploymentDescriptor());
                this._depXml.setApplicationId(tgt.getObjectName().getKeyProperty("name"));
                String parentAppName = tgt.getParentApplicationName();
                AppType appType = new AppType(this._depXml);
                appType.setValue(parentAppName);
                this._depXml.setParentApp(appType);
                WebSiteType webSiteType = new WebSiteType(this._depXml);
                webSiteBinding = tgt.getWebSite();
                webSiteType.setValue(webSiteBinding);
                this._depXml.setWebSiteBinding(webSiteType);
                Map webSiteBindingsMap = tgt.getWebSiteBindings();
                Hashtable webSiteBindingNames = WebSiteBindings.translateWebSites(webSiteBindingsMap);
                this._depXml.setWebSiteBindingNames(webSiteBindingNames);
                BooleanType enableIIOP = new BooleanType(this._depXml, tgt.getIIOPEnabled() ? "true" : "false");
                this._depXml.setEnableIIOP(enableIIOP);
                DDBeanRoot beanRoot = this._deployableObject.getDDBeanRoot();
                String[] xp = new String[]{"application"};
                DDBean[] appBean = beanRoot.getChildBean(xp[0]);
                ApplicationConfigBean appConfigBean = (ApplicationConfigBean)this._depXml.getDConfigBean(appBean[0]);
                this._dataSources = tgt.getDataSourcesDescriptor();
                if (this._dataSources != null && (dsPath = appConfigBean.getDataSourcesPath()) != null && dsPath.length() > 0) {
                    File dsFile = new File(dsPath);
                    appConfigBean.setDataSourcesPath(dsFile.getName());
                }
                if ((jaznConfigBean = appConfigBean.getJazn()) != null && (location = jaznConfigBean.getLocation()) != null && location.length() > 0) {
                    this._jaznData = tgt.getJaznDataDescriptor();
                    this._depXml.initJaznData(this._jaznData);
                }
                if ((loginModules = tgt.getLoginModules()) != null && loginModules.size() > 0) {
                    LoginModuleType[] newModules = new LoginModuleType[loginModules.size()];
                    appConfigBean.addJaznLoginConfig();
                    JaznLoginConfigType jaznLoginConfig = appConfigBean.getJaznLoginConfig();
                    for (int n = 0; n < loginModules.size(); ++n) {
                        ArrayList loginModule = (ArrayList)loginModules.get(n);
                        newModules[n] = new LoginModuleType(jaznLoginConfig, null);
                        StringType ctlFlag = newModules[n].defaultControlFlag();
                        ctlFlag.setValue((String)loginModule.get(0));
                        newModules[n].setControlFlag(ctlFlag);
                        newModules[n].setClassName((String)loginModule.get(1));
                        Map options = (Map)loginModule.get(2);
                        if (options == null || options.size() <= 0) continue;
                        OptionType[] newOptions = new OptionType[options.size()];
                        Set optionEntries = options.entrySet();
                        Iterator it = optionEntries.iterator();
                        int opt = 0;
                        while (it.hasNext()) {
                            Map.Entry optionEntry = it.next();
                            newOptions[opt] = new OptionType(newModules[n]);
                            OptionNameType optionName = new OptionNameType(newOptions[opt]);
                            optionName.setValue((String)optionEntry.getKey());
                            newOptions[opt].setName(optionName);
                            newOptions[opt].setValue((String)optionEntry.getValue());
                            ++opt;
                        }
                        newModules[n].setOptions(newOptions);
                    }
                    jaznLoginConfig.setLoginModules(newModules);
                }
            }
            catch (Throwable t) {
                throw new ExtendedInvalidModuleException(t);
            }
            J2eeApplicationObject j2eeApplicationObject = (J2eeApplicationObject)obj;
            String[] moduleUris = j2eeApplicationObject.getModuleUris();
            if (moduleUris == null || moduleUris.length <= 0) return;
            block12: for (int n = 0; n < moduleUris.length; ++n) {
                DeployableObject moduleObj = j2eeApplicationObject.getDeployableObject(moduleUris[n]);
                TargetModuleID[] tgts = tgt.getChildTargetModuleID();
                if (tgts == null) continue;
                for (int t = 0; t < tgts.length; ++t) {
                    TargetModuleNode childNode = new TargetModuleNode(tgts[t]);
                    String childNodeName = childNode.toString();
                    if (childNodeName.substring(0, 1).equals("\"")) {
                        childNodeName = childNodeName.substring(1, childNodeName.length() - 1);
                    }
                    String moduleUriWithoutExt = moduleUris[n].indexOf(".") > 0 ? moduleUris[n].substring(0, moduleUris[n].indexOf(".")) : moduleUris[n];
                    if (moduleObj.getType() != childNode.retrieveModuleType() || !moduleUriWithoutExt.equals(childNodeName)) continue;
                    ConfigBeanRootNode depXml = null;
                    ConfigBeanRootNode wsDepXml = null;
                    try {
                        depXml = ConfigBeanRootNode.createConf(moduleObj, moduleUris[n], mgr, this._depXml, ((ProprietaryTargetModuleID)tgts[t]).getProprietaryDeploymentDescriptor());
                        if (moduleObj.getType().equals(ModuleType.WAR) && webSiteBinding != null) {
                            WarDepXml warDepXml = (WarDepXml)depXml;
                            Map webBindings = tgt.getWebBindings(webSiteBinding);
                            WebBinding webBinding = (WebBinding)webBindings.get(moduleUriWithoutExt);
                            if (webBinding != null) {
                                warDepXml.setContextRoot(webBinding.getRootContext());
                                warDepXml.setAccessLog(webBinding.getAccessLog());
                            }
                        }
                        this._childConf.put(moduleUris[n], depXml);
                    }
                    catch (Throwable thr) {
                        throw new ExtendedInvalidModuleException(thr);
                    }
                    if (!moduleObj.getType().equals(ModuleType.EJB) && !moduleObj.getType().equals(ModuleType.WAR)) continue block12;
                    try {
                        wsDepXml = ConfigBeanRootNode.createWSConf(moduleObj, moduleUris[n] + ":webservices", mgr, this._depXml, depXml, ((ProprietaryTargetModuleID)tgts[t]).getProprietaryWSDeploymentDescriptor());
                        if (wsDepXml == null) continue block12;
                        this._childConf.put(moduleUris[n] + ":webservices", wsDepXml);
                        continue block12;
                    }
                    catch (Throwable thr) {
                        throw new ExtendedInvalidModuleException(thr);
                    }
                }
            }
            return;
        }
        try {
            TargetModuleID[] children = tgt.getChildTargetModuleID();
            ProprietaryTargetModuleID thisTgt = tgt;
            if (children != null) {
                thisTgt = (ProprietaryTargetModuleID)children[0];
            }
            this._depXml = ConfigBeanRootNode.createConf(obj, ".", mgr, null, thisTgt.getProprietaryDeploymentDescriptor());
            if (obj.getType().equals(ModuleType.EJB) || obj.getType().equals(ModuleType.WAR)) {
                this._WSDepXml = ConfigBeanRootNode.createWSConf(obj, ".:webservices", mgr, null, this._depXml, thisTgt.getProprietaryWSDeploymentDescriptor());
            }
        }
        catch (Throwable t) {
            throw new ExtendedInvalidModuleException(t);
        }
        if (!obj.getType().equals(ModuleType.WAR) && !obj.getType().equals(ModuleType.EJB) && !obj.getType().equals(ModuleType.CAR)) return;
        try {
            this._depXml.setApplicationId(tgt.getObjectName().getKeyProperty("name"));
            String parentAppName = tgt.getParentApplicationName();
            AppType appType = new AppType(this._depXml);
            appType.setValue(parentAppName);
            this._depXml.setParentApp(appType);
            if (!obj.getType().equals(ModuleType.WAR)) return;
            Map webSiteBindingsMap = tgt.getWebSiteBindings();
            Hashtable webSiteBindingNames = WebSiteBindings.translateWebSites(webSiteBindingsMap);
            this._depXml.setWebSiteBindingNames(webSiteBindingNames);
            return;
        }
        catch (Throwable t) {
            throw new ExtendedInvalidModuleException(t);
        }
    }

    public DeployableObject getDeployableObject() {
        return this._deployableObject;
    }

    public DConfigBeanRoot getDConfigBeanRoot(DDBeanRoot bean) throws ConfigurationException {
        try {
            if (this._deployableObject.getType().equals(ModuleType.EAR)) {
                J2eeApplicationObject j2eeApplicationObject = (J2eeApplicationObject)this._deployableObject;
                if (bean.getType().equals(ModuleType.EAR)) {
                    if (this._depXml == null) {
                        this._depXml = ConfigBeanRootNode.createConf(this._deployableObject, ".", this._mgr, null, null);
                    } else {
                        this._depXml.putDDBean((DDBean)bean);
                    }
                    return this._depXml;
                }
                String[] uris = j2eeApplicationObject.getModuleUris();
                if (uris != null) {
                    for (int n = 0; n < uris.length; ++n) {
                        DeployableObject obj = j2eeApplicationObject.getDeployableObject(uris[n]);
                        DDBeanRoot objRoot = obj.getDDBeanRoot();
                        DDBeanRoot wsObjRoot = null;
                        ConfigBeanRootNode rootNode = (ConfigBeanRootNode)this._childConf.get(uris[n]);
                        if (rootNode == null) {
                            rootNode = ConfigBeanRootNode.createConf(obj, uris[n], this._mgr, this._depXml, null);
                            this._childConf.put(uris[n], rootNode);
                        }
                        if (objRoot == bean) {
                            rootNode.putDDBean((DDBean)bean);
                            return rootNode;
                        }
                        if (!bean.getFilename().endsWith("webservices.xml")) continue;
                        try {
                            wsObjRoot = obj.getDDBeanRoot(bean.getFilename());
                        }
                        catch (FileNotFoundException ex) {
                            continue;
                        }
                        if (wsObjRoot != bean) continue;
                        ConfigBeanRootNode wsRootNode = (ConfigBeanRootNode)this._childConf.get(uris[n] + ":webservices");
                        if (wsRootNode == null) {
                            wsRootNode = ConfigBeanRootNode.createWSConf(obj, uris[n] + ":webservices", this._mgr, this._depXml, rootNode, null);
                            this._childConf.put(uris[n] + ":webservices", wsRootNode);
                        }
                        wsRootNode.putDDBean((DDBean)bean);
                        return wsRootNode;
                    }
                }
            } else {
                if (this._depXml == null) {
                    this._depXml = ConfigBeanRootNode.createConf(this._deployableObject, ".", this._mgr, null, null);
                }
                if (this._deployableObject.getType().equals(bean.getType()) && this._deployableObject.getDDBeanRoot() == bean) {
                    this._depXml.putDDBean((DDBean)bean);
                    return this._depXml;
                }
                if (this._deployableObject.getType().equals(bean.getType()) && this._deployableObject.getDDBeanRoot(bean.getFilename()) == bean) {
                    if (this._WSDepXml == null) {
                        this._WSDepXml = ConfigBeanRootNode.createWSConf(this._deployableObject, ".:webservices", this._mgr, this._depXml, this._depXml, null);
                    }
                    this._WSDepXml.putDDBean((DDBean)bean);
                    return this._WSDepXml;
                }
            }
            return null;
        }
        catch (Throwable t) {
            throw new ExtendedConfigurationException(t);
        }
    }

    public void removeDConfigBean(DConfigBeanRoot bean) throws BeanNotFoundException {
        if (bean instanceof ConfigBeanRootNode) {
            if (this._depXml == (ConfigBeanRootNode)bean) {
                try {
                    this._depXml = ConfigBeanRootNode.createConf(this._deployableObject, ".", this._mgr, null, null);
                }
                catch (Throwable t) {
                    throw new ExtendedRuntimeException(t);
                }
                return;
            }
            if (this._depXml instanceof EarDepXml) {
                String foundKey = null;
                Set values = this._childConf.entrySet();
                Iterator it = values.iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    if ((ConfigBeanRootNode)bean != (ConfigBeanRootNode)entry.getValue()) continue;
                    foundKey = (String)entry.getKey();
                    break;
                }
                if (foundKey != null) {
                    J2eeApplicationObject j2eeApplicationObject = (J2eeApplicationObject)this._deployableObject;
                    DeployableObject moduleObj = j2eeApplicationObject.getDeployableObject(foundKey);
                    try {
                        ConfigBeanRootNode depXml = ConfigBeanRootNode.createConf(moduleObj, foundKey, this._mgr, this._depXml, null);
                        this._childConf.put(foundKey, depXml);
                    }
                    catch (Throwable t) {
                        throw new ExtendedRuntimeException(t);
                    }
                    return;
                }
            }
        }
        throw new BeanNotFoundException(FormattingResourceBundle.DeploymentMessages.getString("noDConfigBean"));
    }

    public DConfigBeanRoot restoreDConfigBean(InputStream inputArchive, DDBeanRoot bean) throws ConfigurationException {
        J2eeApplicationObject j2eeApplicationObject;
        DeployableObject[] allDOs;
        DeployableObject affectedDO = null;
        String affectedURI = null;
        if (this._deployableObject.getDDBeanRoot() == bean) {
            affectedDO = this._deployableObject;
            affectedURI = ".";
        } else if (this._deployableObject instanceof J2eeApplicationObject && (allDOs = (j2eeApplicationObject = (J2eeApplicationObject)this._deployableObject).getDeployableObjects(bean.getType())) != null) {
            block0: for (int n = 0; n < allDOs.length; ++n) {
                if (allDOs[n].getDDBeanRoot() != bean) continue;
                affectedDO = allDOs[n];
                String[] uris = j2eeApplicationObject.getModuleUris(bean.getType());
                int u = 0;
                while (u < uris.length) {
                    if (j2eeApplicationObject.getDeployableObject(uris[n]) == affectedDO) {
                        affectedURI = uris[n];
                        break block0;
                    }
                    ++n;
                }
                break;
            }
        }
        if (affectedDO == null || affectedURI == null) {
            throw new ConfigurationException(FormattingResourceBundle.DeploymentMessages.getString("unknownDDBeanRoot"));
        }
        return this.restore(inputArchive, affectedURI);
    }

    public void saveDConfigBean(OutputStream outputArchive, DConfigBeanRoot bean) throws ConfigurationException {
        if (outputArchive == null) {
            throw new IllegalArgumentException();
        }
        if (bean == null || !(bean instanceof ConfigBeanRootNode)) {
            throw new IllegalArgumentException();
        }
        PrintWriter out = new PrintWriter(outputArchive);
        if (this._depXml == (ConfigBeanRootNode)bean) {
            this.saveAppAttrs(out);
            this._depXml.writeConfig(out);
        } else if (this._childConf.contains((ConfigBeanRootNode)bean)) {
            ((ConfigBeanRootNode)bean).writeConfig(out);
        } else {
            throw new IllegalArgumentException();
        }
        out.flush();
        out.close();
    }

    public void restore(InputStream inputArchive) throws ConfigurationException {
        this.restore(inputArchive, null);
    }

    private DConfigBeanRoot restore(InputStream inputArchive, String uri) throws ConfigurationException {
        ConfigBeanRootNode ret = null;
        String moduleType = "";
        String applicationName = null;
        String webBinding = null;
        String webSiteBindings = null;
        String parentApp = null;
        String contextRoot = "";
        String enableIIOP = null;
        String removeArchive = null;
        String failureRecovery = null;
        Object xmlFile = null;
        boolean errorOccurred = false;
        Hashtable parsedConf = null;
        try {
            String docType;
            String xmlContent;
            String moduleUri;
            parsedConf = DeplConfiguration.parseConfiguration(inputArchive);
            Hashtable attributes = (Hashtable)parsedConf.get("attributes");
            moduleType = (String)attributes.get("moduleType");
            String depEntry = DeplConfiguration.ModuleToDepEntry(moduleType);
            if (!(uri != null && !uri.equals(".") || depEntry != null && depEntry.length() != 0)) {
                throw new ConfigurationException(FormattingResourceBundle.DeploymentMessages.getString("wrongArgumentType", new String[]{"restore"}));
            }
            applicationName = (String)attributes.get("applicationID");
            webBinding = (String)attributes.get("bindWebApp");
            webSiteBindings = (String)attributes.get("webSiteBindings");
            parentApp = (String)attributes.get("parent");
            contextRoot = (String)attributes.get("contextRoot");
            enableIIOP = (String)attributes.get("enableIIOP");
            removeArchive = (String)attributes.get("removeArchive");
            failureRecovery = (String)attributes.get("failureRecovery");
            Hashtable docTypes = (Hashtable)parsedConf.get("docTypes");
            Hashtable modules = (Hashtable)parsedConf.get("modules");
            Hashtable webSiteMap = WebSiteBindings.parseWebSiteBindings(webSiteBindings);
            this._depXml.setWebSiteBindingNames(webSiteMap);
            if (uri == null || uri.equals(".")) {
                try {
                    moduleUri = ".";
                    xmlContent = (String)modules.get(moduleUri);
                    docType = (String)docTypes.get(moduleUri);
                    this._depXml = ConfigBeanRootNode.createConf(this._deployableObject, moduleUri, this._mgr, null, xmlContent);
                    this._depXml.setApplicationId(applicationName);
                    this._depXml.setWebSiteBindingNames(webSiteMap);
                    WebSiteType webSiteType = new WebSiteType(this._depXml);
                    webSiteType.setValue(webBinding);
                    this._depXml.setWebSiteBinding(webSiteType);
                    AppType appType = new AppType(this._depXml);
                    appType.setValue(parentApp);
                    this._depXml.setParentApp(appType);
                    if ("true".equals(enableIIOP)) {
                        this._depXml.setEnableIIOP(new BooleanType(this._depXml, "true"));
                    }
                    if ("true".equals(removeArchive)) {
                        this._depXml.setRemoveArchive(new BooleanType(this._depXml, "true"));
                    }
                    if ("true".equals(failureRecovery)) {
                        this._depXml.setFailureRecovery(new BooleanType(this._depXml, "true"));
                    }
                    if (moduleType.equals(ModuleType.WAR.toString()) && contextRoot != null) {
                        ((WarDepXml)this._depXml).setContextRoot(contextRoot);
                    }
                    ret = this._depXml;
                }
                catch (Exception ex) {
                    if (logger_.isLoggable(Level.SEVERE)) {
                        logger_.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                    errorOccurred = true;
                }
            }
            if (uri == null || uri.equals(".:webservices")) {
                try {
                    moduleUri = ".:webservices";
                    xmlContent = (String)modules.get(moduleUri);
                    if (xmlContent != null) {
                        docType = (String)docTypes.get(moduleUri);
                        this._WSDepXml = ConfigBeanRootNode.createWSConf(this._deployableObject, moduleUri, this._mgr, null, this._depXml, xmlContent);
                    }
                }
                catch (Exception ex) {
                    if (logger_.isLoggable(Level.SEVERE)) {
                        logger_.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                    errorOccurred = true;
                }
            }
            if (uri == null || uri.equals("data-sources")) {
                this._dataSources = (String)modules.get("data-sources");
            }
            if (uri == null || uri.equals("jazn-data")) {
                this._jaznData = (String)modules.get("jazn-data");
                if (this._jaznData != null) {
                    this._depXml.initJaznData(this._jaznData);
                }
            }
            Enumeration moduleUris = modules.keys();
            while (moduleUris.hasMoreElements()) {
                String moduleUri2 = (String)moduleUris.nextElement();
                String xmlContent2 = (String)modules.get(moduleUri2);
                String docType2 = (String)docTypes.get(moduleUri2);
                boolean isWS = moduleUri2.endsWith(":webservices");
                if (errorOccurred) continue;
                try {
                    if (uri != null && !moduleUri2.equals(uri) || moduleUri2.equals(".") || moduleUri2.equals(".:webservices") || moduleUri2.equals("data-sources") || moduleUri2.equals("jazn-data")) continue;
                    J2eeApplicationObject j2eeApplicationObject = (J2eeApplicationObject)this._deployableObject;
                    if (isWS) {
                        int moduleUriIndex = moduleUri2.indexOf(":webservices");
                        moduleUri2 = moduleUri2.substring(0, moduleUriIndex);
                        DeployableObject moduleObj = j2eeApplicationObject.getDeployableObject(moduleUri2);
                        ConfigBeanRootNode depXml = ConfigBeanRootNode.createWSConf(moduleObj, moduleUri2 + ":webservices", this._mgr, this._depXml, (ConfigBeanRootNode)this._childConf.get(moduleUri2), xmlContent2);
                        this._childConf.put(moduleUri2 + ":webservices", depXml);
                        if (ret != null) continue;
                        ret = depXml;
                        continue;
                    }
                    DeployableObject moduleObj = j2eeApplicationObject.getDeployableObject(moduleUri2);
                    ConfigBeanRootNode depXml = ConfigBeanRootNode.createConf(moduleObj, moduleUri2, this._mgr, this._depXml, xmlContent2);
                    this._childConf.put(moduleUri2, depXml);
                    ConfigBeanRootNode wsDepXml = (ConfigBeanRootNode)this._childConf.get(moduleUri2 + ":webservices");
                    if (wsDepXml != null) {
                        String path = null;
                        path = moduleObj.getType().equals(ModuleType.WAR) ? "WEB-INF/webservices.xml" : "META-INF/webservices.xml";
                        depXml.setDConfigBean(path, wsDepXml);
                    }
                    if (ret != null) continue;
                    ret = depXml;
                }
                catch (Exception ex) {
                    if (logger_.isLoggable(Level.SEVERE)) {
                        logger_.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                    errorOccurred = true;
                }
            }
        }
        catch (Throwable t) {
            throw new ExtendedConfigurationException(t);
        }
        return ret;
    }

    public void save(OutputStream outputArchive) throws ConfigurationException {
        if (outputArchive == null) {
            throw new IllegalArgumentException();
        }
        if (this._depXml == null) {
            throw new ConfigurationException();
        }
        PrintWriter out = null;
        try {
            out = new PrintWriter(new OutputStreamWriter(outputArchive, "UTF-8"));
        }
        catch (UnsupportedEncodingException unEx) {
            out = new PrintWriter(outputArchive);
        }
        this.saveAppAttrs(out);
        this._depXml.writeConfig(out);
        if (this._WSDepXml != null) {
            this._WSDepXml.writeConfig(out);
        }
        if (this._dataSources != null) {
            out.println("moduleID=data-sources");
            out.println("doctype=data-sources");
            out.println(this._dataSources);
        }
        if (this._jaznData != null) {
            out.println("moduleID=jazn-data");
            out.println("doctype=jazn-data");
            out.println(this._jaznData);
        }
        try {
            Enumeration moduleUris = this._childConf.keys();
            while (moduleUris.hasMoreElements()) {
                String moduleUri = (String)moduleUris.nextElement();
                ConfigBeanRootNode moduleXml = (ConfigBeanRootNode)this._childConf.get(moduleUri);
                moduleXml.writeConfig(out);
            }
        }
        catch (Throwable t) {
            throw new ExtendedConfigurationException(t);
        }
        out.flush();
        out.close();
    }

    private void saveAppAttrs(PrintWriter out) throws ExtendedConfigurationException {
        try {
            String contextRoot;
            BooleanType failureRecovery;
            BooleanType removeArchive;
            out.println("moduleType=" + this._deployableObject.getType().toString());
            String appId = this._depXml.getApplicationId();
            if (appId == null || appId.trim().equals("null")) {
                appId = "";
            }
            out.println("applicationID=" + appId);
            WebSiteType webSiteType = this._depXml.getWebSiteBinding();
            String webSiteBinding = "";
            if (webSiteType != null) {
                webSiteBinding = webSiteType.getValue();
            }
            if (webSiteBinding == null || webSiteBinding.trim().equals("null")) {
                webSiteBinding = "";
            }
            out.println("bindWebApp=" + webSiteBinding);
            Hashtable webBindings = this._depXml.getWebSiteBindings();
            if (webBindings != null) {
                out.print("webSiteBindings=");
                Set values = webBindings.entrySet();
                Iterator it = values.iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    String moduleName = (String)entry.getKey();
                    WebSiteBindingType[] sites = (WebSiteBindingType[])entry.getValue();
                    String moduleNameWithoutExt = moduleName.equals(".") ? "." : (moduleName.indexOf(".") > 0 ? moduleName.substring(0, moduleName.indexOf(".")) : moduleName);
                    out.print(moduleNameWithoutExt + ":");
                    if (sites != null) {
                        for (int n = 0; n < sites.length; ++n) {
                            out.print(sites[n]);
                            if (sites.length <= 1 || n >= sites.length - 1) continue;
                            out.print(",");
                        }
                    }
                    if (!it.hasNext()) continue;
                    out.print(";");
                }
                out.println();
            }
            AppType appType = this._depXml.getParentApp();
            String parentApp = "";
            if (appType != null) {
                parentApp = appType.getValue();
            }
            if (parentApp == null || parentApp.trim().equals("null")) {
                parentApp = "";
            }
            out.println("parent=" + parentApp);
            BooleanType enableIIOP = this._depXml.getEnableIIOP();
            if (enableIIOP != null && "true".equals(enableIIOP.getValue())) {
                out.println("enableIIOP=true");
            }
            if ((removeArchive = this._depXml.getRemoveArchive()) != null && "true".equals(removeArchive.getValue())) {
                out.println("removeArchive=true");
            }
            if ((failureRecovery = this._depXml.getFailureRecovery()) != null && "true".equals(failureRecovery.getValue())) {
                out.println("failureRecovery=true");
            }
            if (this._depXml instanceof WarDepXml && (contextRoot = ((WarDepXml)this._depXml).getContextRoot()) != null && contextRoot.length() > 0) {
                out.println("contextRoot=" + contextRoot);
            }
        }
        catch (Throwable t) {
            throw new ExtendedConfigurationException(t);
        }
    }

    public static Hashtable parseConfiguration(InputStream inputConf) {
        int ATTRS = 1;
        int XML = 2;
        StringWriter stringStrm = null;
        try {
            Hashtable ret = new Hashtable(3);
            Hashtable<String, String> attributes = new Hashtable<String, String>();
            Hashtable<String, String> docTypes = new Hashtable<String, String>();
            Hashtable<String, String> modules = new Hashtable<String, String>();
            ret.put("attributes", attributes);
            ret.put("docTypes", docTypes);
            ret.put("modules", modules);
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputConf, "UTF-8"));
            String moduleUri = "";
            String docType = "<>";
            String ln = reader.readLine();
            int state = ATTRS;
            while (ln != null) {
                if (state == ATTRS) {
                    StringTokenizer tokens = new StringTokenizer(ln, "=");
                    if (tokens.countTokens() == 1 || tokens.countTokens() == 2) {
                        String attributeName = tokens.nextToken();
                        if (attributeName.equals("moduleID")) {
                            moduleUri = tokens.nextToken();
                            stringStrm = new StringWriter();
                        } else if (attributeName.equals("doctype")) {
                            state = XML;
                            docType = tokens.nextToken();
                        } else if (tokens.countTokens() == 1) {
                            attributes.put(attributeName, tokens.nextToken());
                        }
                    }
                } else if (state == XML) {
                    stringStrm.write(ln + "\n");
                    if (ln.indexOf(docType) > 0 && ln.indexOf("DOCTYPE") == -1 && (ln.indexOf("</") >= 0 && ln.indexOf("</") < ln.indexOf(docType) && ln.indexOf(">") > ln.indexOf(docType) || ln.indexOf("/>") >= 0 && ln.indexOf("/>") > ln.indexOf(docType) && ln.indexOf("<") >= 0 && ln.indexOf("<") < ln.indexOf(docType))) {
                        docTypes.put(moduleUri, docType);
                        stringStrm.flush();
                        stringStrm.close();
                        String buf = stringStrm.toString();
                        attributes.put(moduleUri, buf);
                        modules.put(moduleUri, buf);
                        state = ATTRS;
                    }
                }
                ln = reader.readLine();
            }
            ln = reader.readLine();
            while (ln != null) {
                ln = reader.readLine();
            }
            return ret;
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public static String ModuleToDepEntry(String module) {
        if (module != null) {
            if (module.equals(ModuleType.EAR.toString())) {
                return "META-INF/orion-application.xml";
            }
            if (module.equals(ModuleType.EJB.toString())) {
                return "META-INF/orion-ejb-jar.xml";
            }
            if (module.equals(ModuleType.WAR.toString())) {
                return "WEB-INF/orion-web.xml";
            }
            if (module.equals(ModuleType.CAR.toString())) {
                return "META-INF/orion-application-client.xml";
            }
            if (module.equals(ModuleType.RAR.toString())) {
                return "META-INF/oc4j-ra.xml";
            }
        }
        return "";
    }

    public static String DocTypeToDepEntry(String docType) {
        if (docType != null) {
            if (docType.equals("orion-application")) {
                return "META-INF/orion-application.xml";
            }
            if (docType.equals("orion-ejb-jar")) {
                return "META-INF/orion-ejb-jar.xml";
            }
            if (docType.equals("orion-web-app")) {
                return "WEB-INF/orion-web.xml";
            }
            if (docType.equals("orion-application-client")) {
                return "META-INF/orion-application-client.xml";
            }
            if (docType.equals("connector-factory")) {
                return "META-INF/oc4j-ra.xml";
            }
        }
        return "";
    }

    public static boolean validateAppName(String appName) {
        if (appName != null) {
            for (int n = 0; n < invalidAppChars.length(); ++n) {
                if (appName.indexOf(invalidAppChars.charAt(n)) < 0) continue;
                return false;
            }
        }
        return true;
    }
}

