/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.factories;

import com.evermind.security.User;
import com.evermind.server.ThreadState;
import java.util.StringTokenizer;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import oracle.oc4j.admin.deploy.spi.Oc4jDeploymentManager;
import oracle.oc4j.admin.deploy.spi.factories.DeploymentFactoryBase;
import oracle.oc4j.admin.jmx.client.Oc4jDomainFactory;
import oracle.oc4j.admin.jmx.server.Oc4jMBeanServerFactory;
import oracle.oc4j.admin.jmx.shared.Domain;
import oracle.oc4j.security.OC4JPrivilegedAction;
import oracle.oc4j.security.OC4JSecurity;

public class Oc4jLocalDeploymentFactory
extends DeploymentFactoryBase {
    public final boolean handlesURI(String uri) {
        if (super.handlesURI(uri)) {
            StringTokenizer strTok = new StringTokenizer(uri, ":");
            strTok.nextToken();
            if (strTok.hasMoreTokens() && "local".equalsIgnoreCase(strTok.nextToken())) {
                return true;
            }
        }
        return false;
    }

    public final String getDisplayName() {
        return "Oracle's local J2EE deployment factory for standalone OC4J";
    }

    public final DeploymentManager getDeploymentManager(final String uri, final String username, final String password) throws DeploymentManagerCreationException {
        if (!OC4JSecurity.isSecurityOn()) {
            return this.unprivileged_getDeploymentManager(uri, username, password);
        }
        OC4JPrivilegedAction action = new OC4JPrivilegedAction(){

            public Object oc4jRun() throws DeploymentManagerCreationException {
                return Oc4jLocalDeploymentFactory.this.unprivileged_getDeploymentManager(uri, username, password);
            }
        };
        try {
            return (DeploymentManager)OC4JSecurity.doPrivileged((OC4JPrivilegedAction)action);
        }
        catch (DeploymentManagerCreationException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private final DeploymentManager unprivileged_getDeploymentManager(String uri, String username, String password) throws DeploymentManagerCreationException {
        if (!this.handlesURI(uri)) {
            throw new DeploymentManagerCreationException("This deployment factory cannot handle uri: " + uri);
        }
        ThreadState tst = ThreadState.getCurrentState();
        if (tst == null) {
            throw new DeploymentManagerCreationException("No available authenticated user");
        }
        User user = tst.getUser();
        if (user == null || user.getName() == null || user.getPassword() == null) {
            throw new DeploymentManagerCreationException("No available authenticated user");
        }
        MBeanServer mbsrv = Oc4jMBeanServerFactory.getMBeanServer();
        String domainURI = "deployer:oc4j:localhost:";
        try {
            ObjectName jvm = new ObjectName("oc4j:j2eeType=JVM,name=single,J2EEServer=standalone");
            Integer rmiPort = (Integer)mbsrv.getAttribute(jvm, "rmiPort");
            domainURI = domainURI + rmiPort;
        }
        catch (Exception e) {
            DeploymentManagerCreationException de = new DeploymentManagerCreationException("Unable to get local RMI port");
            de.initCause((Throwable)e);
            throw de;
        }
        Domain domain = Oc4jDomainFactory.getDomainFromDeployerUrl(domainURI, user.getName(), user.getPassword());
        return new Oc4jDeploymentManager(domain);
    }
}

