/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.AccessMaskType;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.HostAccessesTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.IpAccessesTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.MultipleType;

public class AccessMaskTreeNode
extends ConfigTreeNode
implements ActionListener {
    private AccessMaskType _bean;
    private static final String REMOVE_ACCESS_MASK_MENU_STRING = "Remove Access Mask";
    private JMenuItem _removeAccessMaskMenuItem;

    public AccessMaskTreeNode(ConfigTreeNode rootNode, AccessMaskType bean) {
        super(bean);
        this.setRootNode(rootNode);
        this._bean = bean;
        this._removeAccessMaskMenuItem = new JMenuItem(REMOVE_ACCESS_MASK_MENU_STRING);
        this._removeAccessMaskMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._removeAccessMaskMenuItem.setFont(AccessMaskTreeNode.getFont());
        this._removeAccessMaskMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._removeAccessMaskMenuItem);
    }

    public String viewHeaderString() {
        return "Access Mask";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        Method xmlMethod;
        try {
            xmlMethod = AccessMaskType.class.getMethod("writeHostAccessXML", PrintWriter.class, String.class);
            HostAccessesTreeNode hostAccessesTreeNode = new HostAccessesTreeNode(this.getRootNode(), new MultipleType(this._bean, xmlMethod));
            this.addChild(hostAccessesTreeNode);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
        try {
            xmlMethod = AccessMaskType.class.getMethod("writeIpAccessXML", PrintWriter.class, String.class);
            IpAccessesTreeNode ipAccessesTreeNode = new IpAccessesTreeNode(this.getRootNode(), new MultipleType(this._bean, xmlMethod));
            this.addChild(ipAccessesTreeNode);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(REMOVE_ACCESS_MASK_MENU_STRING) && this.confirmRemove()) {
                this.getParentNode().remove(this);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }
}

