/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigPropertyType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AdminObjectType
extends ConfigBeanNode {
    private List configurationProperties;
    String _adminObjectClass = null;
    String location = null;

    public AdminObjectType(ConfigBeanNode parent) {
        this(parent, null);
    }

    public AdminObjectType(ConfigBeanNode parent, Node node) {
        super(null, parent, node);
        this.init();
    }

    public void setAdminObjectClass(String adminObjectClass) {
        String oldValue = this._adminObjectClass;
        this._adminObjectClass = adminObjectClass;
        this.firePropertyChange("adminObjectClass", oldValue, this._adminObjectClass);
    }

    public String getAdminObjectClass() {
        return this._adminObjectClass;
    }

    public void writeXML(PrintWriter out, String indention) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indention, "adminobject-config");
        if (this.location != null) {
            XMLUtils.writeAttribute(out, indention, "location", this.location);
        }
        XMLUtils.writeTagAttributeEnd(out, indention, "adminobject-config");
        if (this._adminObjectClass != null) {
            XMLUtils.writeTag(out, indention + "\t", "adminobject-class", XMLUtils.encode(this._adminObjectClass));
        }
        if (this.configurationProperties != null) {
            Iterator iter = this.configurationProperties.iterator();
            while (iter.hasNext()) {
                ConfigPropertyType config = (ConfigPropertyType)iter.next();
                config.writeXML(out, indention + "\t");
            }
        }
        XMLUtils.writeTagEnd(out, indention, "adminobject-config");
    }

    public void putXpath() {
        if (this.getConfigParent() != null) {
            this.setXpath("config-property");
        }
    }

    private void init() {
        this.setXpath("adminobject-config");
        if (this.getNode() != null) {
            Node rootNode = this.getNode();
            this.location = XMLUtils.getAttribute(rootNode, "location");
            NodeList nodes = rootNode.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String name = node.getNodeName();
                if (name.equals("adminobject-class")) {
                    this._adminObjectClass = XMLUtils.getValue(node);
                    continue;
                }
                if (!name.equals("config-property")) continue;
                this.addConfigurationProperty(new ConfigPropertyType(this, node));
            }
        }
    }

    private void addConfigurationProperty(ConfigPropertyType property) {
        if (this.configurationProperties == null) {
            this.configurationProperties = new ArrayList();
        }
        this.configurationProperties.add(property);
    }
}

