/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ValueType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AttributeType
extends ConfigBeanNode {
    String _name = null;
    ValueType[] _values = null;

    public AttributeType(ConfigBeanNode parent) throws ConfigurationException {
        this(parent, null);
    }

    public AttributeType(ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(null, parent, node);
        this.init();
    }

    public void setName(String name) {
        String oldValue = this._name;
        this._name = name;
        this.firePropertyChange("name", oldValue, this._name);
    }

    public String getName() {
        return this._name;
    }

    public String defaultName() {
        return "";
    }

    public void setValues(ValueType[] values) {
        this._values = values;
    }

    public ValueType[] getValues() {
        return this._values;
    }

    public ValueType[] defaultValues() {
        return new ValueType[0];
    }

    public void addValues() throws ConfigurationException {
        if (this._values != null) {
            return;
        }
        ValueType[] values = new ValueType[]{new ValueType(this, null)};
        this.setValues(values);
    }

    public void removeValues() {
        if (this._values == null) {
            return;
        }
        this.setValues(null);
    }

    public void addValue(ValueType value) {
        value.setParent(this);
        int existingValuesCnt = 0;
        if (this._values != null) {
            existingValuesCnt = this._values.length;
        }
        ValueType[] newValues = new ValueType[existingValuesCnt + 1];
        for (int n = 0; n < existingValuesCnt; ++n) {
            newValues[n] = this._values[n];
        }
        newValues[existingValuesCnt] = value;
        ValueType[] oldValue = this._values;
        this._values = newValues;
        this.firePropertyChange("values", oldValue, this._values);
    }

    public void removeValue(ValueType value) {
        int existingValuesCnt = 0;
        if (this._values != null) {
            existingValuesCnt = this._values.length;
        }
        ValueType[] newValues = new ValueType[existingValuesCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingValuesCnt; ++n) {
            if (value.equals(this._values[n])) continue;
            newValues[newIndex++] = this._values[n];
        }
        ValueType[] oldValue = this._values;
        this._values = newValues;
        this.firePropertyChange("values", oldValue, this._values);
    }

    public boolean validatePropertyValue(String name, Object value) {
        return !name.equals("name") || value != null && value instanceof String && ((String)value).length() != 0;
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "attribute");
        XMLUtils.writeAttribute(out, indentation, "name", this._name);
        XMLUtils.writeTagAttributeEnd(out, indentation, "attribute");
        AttributeType.writeXML(out, indentation + "\t", this._values);
        XMLUtils.writeTagEnd(out, indentation, "attribute");
    }

    public void writeValuesXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        ValueType.writeXML(out, indentation, this._values);
    }

    private void init() throws ConfigurationException {
        this.setXpath("attribute");
        Vector<ValueType> values = new Vector<ValueType>();
        if (this.getNode() != null) {
            String val = null;
            Node node = this.getNode();
            val = XMLUtils.getAttribute(node, "name");
            if (val != null && !val.trim().equals("")) {
                this._name = val;
            }
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (!name.equals("value")) continue;
                ValueType configBean = new ValueType(this, node);
                values.add(configBean);
            }
        }
        if (values.size() > 0) {
            this._values = values.toArray(new ValueType[0]);
        }
    }
}

