/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.exceptions.ExtendedConfigurationException;
import oracle.oc4j.admin.deploy.spi.xml.AttributeTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.AttributeType;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.MultipleType;

public class AttributesTreeNode
extends ConfigTreeNode
implements ActionListener {
    private ConfigBeanNode _parentBean;
    private static final String ADD_ATTRIBUTE_MENU_STRING = "Add Attribute";
    private JMenuItem _addAttributeMenuItem;
    private AttributeType[] attributesType = new AttributeType[0];
    private Method _readMethod = null;
    private Method _addMethod = null;
    private Method _removeMethod = null;

    public AttributesTreeNode(ConfigTreeNode rootNode, MultipleType attributes) {
        super(attributes);
        this.setRootNode(rootNode);
        this._parentBean = attributes.getConfigParent();
        this._addAttributeMenuItem = new JMenuItem(ADD_ATTRIBUTE_MENU_STRING);
        this._addAttributeMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addAttributeMenuItem.setFont(AttributesTreeNode.getFont());
        this._addAttributeMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addAttributeMenuItem);
        Class<?> beanClass = this._parentBean.getClass();
        try {
            this._readMethod = beanClass.getMethod("getAttributes", null);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._addMethod = beanClass.getMethod("addAttribute", AttributeType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._removeMethod = beanClass.getMethod("removeAttribute", AttributeType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public String viewHeaderString() {
        return "Attributes";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        try {
            AttributeType[] attributes = (AttributeType[])this._readMethod.invoke((Object)this._parentBean, null);
            if (attributes != null) {
                for (int i = 0; i < attributes.length; ++i) {
                    AttributeType attribute = attributes[i];
                    if (attribute == null) continue;
                    AttributeTreeNode attributeTreeNode = new AttributeTreeNode(this.getRootNode(), attribute);
                    this.addChild(attributeTreeNode);
                }
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            AttributeType newAttribute;
            if (event.getActionCommand().equals(ADD_ATTRIBUTE_MENU_STRING) && this.showAddDialog(newAttribute = new AttributeType(this._parentBean), ADD_ATTRIBUTE_MENU_STRING)) {
                this._addMethod.invoke((Object)this._parentBean, newAttribute);
                AttributeTreeNode newNode = new AttributeTreeNode(this, newAttribute);
                this.insertNode(newNode);
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof AttributeTreeNode) {
            try {
                AttributeType attribute = (AttributeType)node.getConfigBeanNode();
                this._removeMethod.invoke((Object)this._parentBean, attribute);
                this.removeNode(node);
            }
            catch (Throwable t) {
                throw new ExtendedConfigurationException(t);
            }
        }
    }
}

