/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.tree.TreePath;
import oracle.oc4j.admin.deploy.gui.ViewableJTree;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.CarMappingsTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTree;
import oracle.oc4j.admin.deploy.spi.xml.EjbRefMappingConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.EnvEntryMappingConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.MailSessionType;
import oracle.oc4j.admin.deploy.spi.xml.MessageDestinationRefMappingType;
import oracle.oc4j.admin.deploy.spi.xml.ResourceEnvRefMappingConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.ResourceRefMappingConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.ServiceRefMappingConfigBean;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class CarModuleConfigBean
extends ConfigBeanNode {
    protected MailSessionType[] _mailSessions = null;

    public CarModuleConfigBean(DDBean stdBean, ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(stdBean, parent, node);
        this.init();
    }

    public CarModuleConfigBean(ConfigBeanNode parent, Node node) throws ConfigurationException {
        this(null, parent, node);
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "orion-application-client");
        XMLUtils.writeAttribute(out, indentation, "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        XMLUtils.writeAttribute(out, indentation, "xsi:noNamespaceSchemaLocation", "http://xmlns.oracle.com/oracleas/schema/orion-application-client-10_0.xsd");
        XMLUtils.writeTagAttributeEnd(out, indentation, "orion-application-client");
        CarModuleConfigBean.writeAll(this.getChildBean("env-entry-mapping"), out, indentation + "\t");
        CarModuleConfigBean.writeAll(this.getChildBean("ejb-ref-mapping"), out, indentation + "\t");
        CarModuleConfigBean.writeAll(this.getChildBean("resource-ref-mapping"), out, indentation + "\t" + "\t");
        CarModuleConfigBean.writeAll(this.getChildBean("resource-env-ref-mapping"), out, indentation + "\t");
        CarModuleConfigBean.writeAll(this.getChildBean("message-destination-ref-mapping"), out, indentation + "\t");
        MailSessionType.writeXML(out, indentation + "\t", this.getMailSessions());
        CarModuleConfigBean.writeAll(this.getChildBean("service-ref-mapping"), out, indentation + "\t");
        XMLUtils.writeTagEnd(out, indentation, "orion-application-client");
    }

    public void writeMailSessionsXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        MailSessionType.writeXML(out, indentation, this._mailSessions);
    }

    private void init() throws ConfigurationException {
        this.setXpath("orion-application-client");
        this._xpaths = new String[6];
        this._xpaths[0] = "resource-ref";
        this._xpaths[1] = "resource-env-ref";
        this._xpaths[2] = "ejb-ref";
        this._xpaths[3] = "env-entry";
        this._xpaths[4] = "service-ref";
        this._xpaths[5] = "message-destination-ref";
        this._configXpaths = new String[6];
        this._configXpaths[0] = "resource-ref-mapping";
        this._configXpaths[1] = "resource-env-ref-mapping";
        this._configXpaths[2] = "ejb-ref-mapping";
        this._configXpaths[3] = "env-entry-mapping";
        this._configXpaths[4] = "service-ref-mapping";
        this._configXpaths[5] = "message-destination-ref-mapping";
        Vector<ResourceRefMappingConfigBean> resRefMaps = new Vector<ResourceRefMappingConfigBean>();
        Vector<ResourceRefMappingConfigBean> resEnvRefMaps = new Vector<ResourceRefMappingConfigBean>();
        Vector<ResourceRefMappingConfigBean> ejbRefMaps = new Vector<ResourceRefMappingConfigBean>();
        Vector<ResourceRefMappingConfigBean> envEntryMaps = new Vector<ResourceRefMappingConfigBean>();
        Vector<MailSessionType> mailSessions = new Vector<MailSessionType>();
        Vector<ResourceRefMappingConfigBean> serviceRefMaps = new Vector<ResourceRefMappingConfigBean>();
        Vector<ResourceRefMappingConfigBean> messageDestinationRefMaps = new Vector<ResourceRefMappingConfigBean>();
        if (this.getNode() != null) {
            Object val = null;
            Node node = this.getNode();
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                ConfigBeanNode configBean;
                node = nodes.item(i);
                String name = node.getNodeName();
                if (name.equals("resource-ref-mapping")) {
                    configBean = new ResourceRefMappingConfigBean(this, node);
                    resRefMaps.add((ResourceRefMappingConfigBean)configBean);
                    continue;
                }
                if (name.equals("resource-env-ref-mapping")) {
                    configBean = new ResourceEnvRefMappingConfigBean(this, node);
                    resEnvRefMaps.add((ResourceRefMappingConfigBean)configBean);
                    continue;
                }
                if (name.equals("ejb-ref-mapping")) {
                    configBean = new EjbRefMappingConfigBean(this, node);
                    ejbRefMaps.add((ResourceRefMappingConfigBean)configBean);
                    continue;
                }
                if (name.equals("env-entry-mapping")) {
                    configBean = new EnvEntryMappingConfigBean(this, node);
                    envEntryMaps.add((ResourceRefMappingConfigBean)configBean);
                    continue;
                }
                if (name.equals("mail-session")) {
                    MailSessionType mailSession = new MailSessionType(this, node);
                    mailSessions.add(mailSession);
                    continue;
                }
                if (name.equals("service-ref-mapping")) {
                    configBean = new ServiceRefMappingConfigBean(this, node);
                    serviceRefMaps.add((ResourceRefMappingConfigBean)configBean);
                    continue;
                }
                if (!name.equals("message-destination-ref-mapping")) continue;
                configBean = new MessageDestinationRefMappingType(this, node);
                messageDestinationRefMaps.add((ResourceRefMappingConfigBean)configBean);
            }
        }
        if (mailSessions.size() > 0) {
            this.setMailSessions(mailSessions.toArray(new MailSessionType[0]));
        }
        this.recordXpathForBeans("resource-ref-mapping", resRefMaps);
        this.recordXpathForBeans("resource-env-ref-mapping", resEnvRefMaps);
        this.recordXpathForBeans("ejb-ref-mapping", ejbRefMaps);
        this.recordXpathForBeans("env-entry-mapping", envEntryMaps);
        this.recordXpathForBeans("service-ref-mapping", serviceRefMaps);
        this.recordXpathForBeans("message-destination-ref-mapping", messageDestinationRefMaps);
    }

    public ViewableJTree[] subTrees() {
        CarMappingsTreeNode treeNode = new CarMappingsTreeNode(this);
        treeNode.setTreePath(new TreePath(treeNode));
        ConfigTree tree = new ConfigTree(treeNode);
        treeNode.setTree(tree);
        return new ViewableJTree[]{tree};
    }

    public void setMailSessions(MailSessionType[] mailSessions) {
        MailSessionType[] oldValue = this._mailSessions;
        this._mailSessions = mailSessions;
        this.firePropertyChange("mailSessions", oldValue, this._mailSessions);
    }

    public MailSessionType[] getMailSessions() {
        return this._mailSessions;
    }

    public MailSessionType[] defaultMailSessions() {
        return new MailSessionType[0];
    }

    public void addMailSessions() {
        if (this._mailSessions != null) {
            return;
        }
        MailSessionType[] mailSessions = new MailSessionType[]{new MailSessionType(this, null)};
        this.setMailSessions(mailSessions);
    }

    public void removeMailSessions() {
        if (this._mailSessions == null) {
            return;
        }
        this.setMailSessions(null);
    }

    public void addMailSession(MailSessionType mailSession) {
        mailSession.setParent(this);
        int existingMailSessionsCnt = 0;
        if (this._mailSessions != null) {
            existingMailSessionsCnt = this._mailSessions.length;
        }
        MailSessionType[] newMailSessions = new MailSessionType[existingMailSessionsCnt + 1];
        for (int n = 0; n < existingMailSessionsCnt; ++n) {
            newMailSessions[n] = this._mailSessions[n];
        }
        newMailSessions[existingMailSessionsCnt] = mailSession;
        MailSessionType[] oldValue = this._mailSessions;
        this._mailSessions = newMailSessions;
        this.firePropertyChange("mailSessions", oldValue, this._mailSessions);
    }

    public void removeMailSession(MailSessionType mailSession) {
        int existingMailSessionsCnt = 0;
        if (this._mailSessions != null) {
            existingMailSessionsCnt = this._mailSessions.length;
        }
        MailSessionType[] newMailSessions = new MailSessionType[existingMailSessionsCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingMailSessionsCnt; ++n) {
            if (mailSession.equals(this._mailSessions[n])) continue;
            newMailSessions[newIndex++] = this._mailSessions[n];
        }
        if (newMailSessions.length == 0) {
            newMailSessions = null;
        }
        MailSessionType[] oldValue = this._mailSessions;
        this._mailSessions = newMailSessions;
        this.firePropertyChange("mailSessions", oldValue, this._mailSessions);
    }
}

