/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ClientOperationRuntimeType;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ClientOperationType
extends ConfigBeanNode {
    String _name = null;
    String _inputName = null;
    String _outputName = null;
    ClientOperationRuntimeType _runtime = null;

    public ClientOperationType(ConfigBeanNode parent) throws ConfigurationException {
        this(parent, null);
    }

    public ClientOperationType(ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(null, parent, node);
        this.init();
    }

    public void setName(String name) {
        String oldValue = this._name;
        this._name = name;
        this.firePropertyChange("name", oldValue, this._name);
    }

    public String getName() {
        return this._name;
    }

    public String defaultName() {
        return "";
    }

    public void setInputName(String inputName) {
        String oldValue = this._inputName;
        this._inputName = inputName;
        this.firePropertyChange("inputName", oldValue, this._inputName);
    }

    public String getInputName() {
        return this._inputName;
    }

    public String defaultInputName() {
        return "";
    }

    public void setOutputName(String outputName) {
        String oldValue = this._outputName;
        this._outputName = outputName;
        this.firePropertyChange("outputName", oldValue, this._outputName);
    }

    public String getOutputName() {
        return this._outputName;
    }

    public String defaultOutputName() {
        return "";
    }

    public void setRuntime(ClientOperationRuntimeType runtime) throws ConfigurationException {
        ClientOperationRuntimeType oldValue = this._runtime;
        this._runtime = runtime;
        this.firePropertyChange("runtime", oldValue, this._runtime);
    }

    public ClientOperationRuntimeType getRuntime() {
        return this._runtime;
    }

    public ClientOperationRuntimeType defaultRuntime() throws ConfigurationException {
        try {
            return new ClientOperationRuntimeType(this, null);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void addRuntime() throws ConfigurationException {
        if (this._runtime != null) {
            return;
        }
        ClientOperationRuntimeType runtime = new ClientOperationRuntimeType(this, null);
        this.setRuntime(runtime);
    }

    public void removeRuntime() throws ConfigurationException {
        if (this._runtime == null) {
            return;
        }
        this.setRuntime(null);
    }

    public boolean validatePropertyValue(String name, Object value) {
        return !name.equals("name") || value != null && value instanceof String && ((String)value).length() != 0;
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "operation");
        XMLUtils.writeAttribute(out, indentation, "name", this._name);
        XMLUtils.writeAttribute(out, indentation, "inputName", this._inputName);
        XMLUtils.writeAttribute(out, indentation, "outputName", this._outputName);
        XMLUtils.writeTagAttributeEnd(out, indentation, "operation");
        if (this._runtime != null) {
            this._runtime.writeXML(out, indentation + "\t");
        }
        XMLUtils.writeTagEnd(out, indentation, "operation");
    }

    public static void writeXML(PrintWriter out, String indentation, ClientOperationType[] operations) throws ExtendedRuntimeException {
        if (operations == null) {
            return;
        }
        XMLUtils.writeTagStart(out, indentation, "operations");
        for (int n = 0; n < operations.length; ++n) {
            operations[n].writeXML(out, indentation + "\t");
        }
        XMLUtils.writeTagEnd(out, indentation, "operations");
    }

    private void init() throws ConfigurationException {
        this.setXpath("operations/operation");
        if (this.getNode() != null) {
            String val = null;
            Node node = this.getNode();
            val = XMLUtils.getAttribute(node, "name");
            if (val != null && !val.trim().equals("")) {
                this._name = val;
            }
            if ((val = XMLUtils.getAttribute(node, "inputName")) != null && !val.trim().equals("")) {
                this._inputName = val;
            }
            if ((val = XMLUtils.getAttribute(node, "outputName")) != null && !val.trim().equals("")) {
                this._outputName = val;
            }
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (!name.equals("runtime")) continue;
                ClientOperationRuntimeType runtime = new ClientOperationRuntimeType(this, node);
                this.setRuntime(runtime);
            }
        }
    }
}

