/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.exceptions.ExtendedConfigurationException;
import oracle.oc4j.admin.deploy.spi.xml.ClientOperationTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.ClientOperationType;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.MultipleType;

public class ClientOperationsTreeNode
extends ConfigTreeNode
implements ActionListener {
    private ConfigBeanNode _parentBean;
    private static final String ADD_CLIENT_OPERATION_MENU_STRING = "Add Client Operation";
    private JMenuItem _addClientOperationMenuItem;
    private ClientOperationType[] clientOperationsType = new ClientOperationType[0];
    private Method _readMethod = null;
    private Method _addMethod = null;
    private Method _removeMethod = null;

    public ClientOperationsTreeNode(ConfigTreeNode rootNode, MultipleType clientOperations) {
        super(clientOperations);
        this.setRootNode(rootNode);
        this._parentBean = clientOperations.getConfigParent();
        this._addClientOperationMenuItem = new JMenuItem(ADD_CLIENT_OPERATION_MENU_STRING);
        this._addClientOperationMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addClientOperationMenuItem.setFont(ClientOperationsTreeNode.getFont());
        this._addClientOperationMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addClientOperationMenuItem);
        Class<?> beanClass = this._parentBean.getClass();
        try {
            this._readMethod = beanClass.getMethod("getClientOperations", null);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._addMethod = beanClass.getMethod("addClientOperation", ClientOperationType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._removeMethod = beanClass.getMethod("removeClientOperation", ClientOperationType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public String viewHeaderString() {
        return "Client Operations";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        try {
            ClientOperationType[] clientOperations = (ClientOperationType[])this._readMethod.invoke((Object)this._parentBean, null);
            if (clientOperations != null) {
                for (int i = 0; i < clientOperations.length; ++i) {
                    ClientOperationType clientOperation = clientOperations[i];
                    if (clientOperation == null) continue;
                    ClientOperationTreeNode clientOperationTreeNode = new ClientOperationTreeNode(this.getRootNode(), clientOperation);
                    this.addChild(clientOperationTreeNode);
                }
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(ADD_CLIENT_OPERATION_MENU_STRING)) {
                ClientOperationType newClientOperation = new ClientOperationType(this._parentBean);
                this._addMethod.invoke((Object)this._parentBean, newClientOperation);
                ClientOperationTreeNode newNode = new ClientOperationTreeNode(this, newClientOperation);
                this.insertNode(newNode);
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof ClientOperationTreeNode) {
            try {
                ClientOperationType clientOperation = (ClientOperationType)node.getConfigBeanNode();
                this._removeMethod.invoke((Object)this._parentBean, clientOperation);
                this.removeNode(node);
            }
            catch (Throwable t) {
                throw new ExtendedConfigurationException(t);
            }
        }
    }
}

