/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.EncryptElementsConfigType;
import oracle.oc4j.admin.deploy.spi.xml.EncryptionMethodsConfigType;
import oracle.oc4j.admin.deploy.spi.xml.KeyTransportMethodsConfigType;
import oracle.oc4j.admin.deploy.spi.xml.PropertyConfigBean;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DecryptConfigType
extends ConfigBeanNode {
    EncryptionMethodsConfigType _encryptionMethods = null;
    KeyTransportMethodsConfigType _keyTransportMethods = null;
    EncryptElementsConfigType _tbeElements = null;
    PropertyConfigBean[] _properties = null;

    public DecryptConfigType(ConfigBeanNode parent) throws ConfigurationException {
        this(parent, null);
    }

    public DecryptConfigType(ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(null, parent, node);
        this.init();
    }

    public void setEncryptionMethods(EncryptionMethodsConfigType encryptionMethods) throws ConfigurationException {
        EncryptionMethodsConfigType oldValue = this._encryptionMethods;
        this._encryptionMethods = encryptionMethods;
        this.firePropertyChange("encryptionMethods", oldValue, this._encryptionMethods);
    }

    public EncryptionMethodsConfigType getEncryptionMethods() {
        return this._encryptionMethods;
    }

    public EncryptionMethodsConfigType defaultEncryptionMethods() {
        try {
            return new EncryptionMethodsConfigType(this, null);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void addEncryptionMethods() throws ConfigurationException {
        if (this._encryptionMethods != null) {
            return;
        }
        EncryptionMethodsConfigType encryptionMethods = new EncryptionMethodsConfigType(this, null);
        this.setEncryptionMethods(encryptionMethods);
    }

    public void removeEncryptionMethods() throws ConfigurationException {
        if (this._encryptionMethods == null) {
            return;
        }
        this.setEncryptionMethods(null);
    }

    public void setKeyTransportMethods(KeyTransportMethodsConfigType keyTransportMethods) throws ConfigurationException {
        KeyTransportMethodsConfigType oldValue = this._keyTransportMethods;
        this._keyTransportMethods = keyTransportMethods;
        this.firePropertyChange("keyTransportMethods", oldValue, this._keyTransportMethods);
    }

    public KeyTransportMethodsConfigType getKeyTransportMethods() {
        return this._keyTransportMethods;
    }

    public KeyTransportMethodsConfigType defaultKeyTransportMethods() {
        try {
            return new KeyTransportMethodsConfigType(this, null);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void addKeyTransportMethods() throws ConfigurationException {
        if (this._keyTransportMethods != null) {
            return;
        }
        KeyTransportMethodsConfigType keyTransportMethods = new KeyTransportMethodsConfigType(this, null);
        this.setKeyTransportMethods(keyTransportMethods);
    }

    public void removeKeyTransportMethods() throws ConfigurationException {
        if (this._keyTransportMethods == null) {
            return;
        }
        this.setKeyTransportMethods(null);
    }

    public void setTbeElements(EncryptElementsConfigType tbeElements) throws ConfigurationException {
        EncryptElementsConfigType oldValue = this._tbeElements;
        this._tbeElements = tbeElements;
        this.firePropertyChange("tbeElements", oldValue, this._tbeElements);
    }

    public EncryptElementsConfigType getTbeElements() {
        return this._tbeElements;
    }

    public EncryptElementsConfigType defaultTbeElements() {
        try {
            return new EncryptElementsConfigType(this, null);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void addTbeElements() throws ConfigurationException {
        if (this._tbeElements != null) {
            return;
        }
        EncryptElementsConfigType tbeElements = new EncryptElementsConfigType(this, null);
        this.setTbeElements(tbeElements);
    }

    public void removeTbeElements() throws ConfigurationException {
        if (this._tbeElements == null) {
            return;
        }
        this.setTbeElements(null);
    }

    public void setProperties(PropertyConfigBean[] properties) throws ConfigurationException {
        PropertyConfigBean[] oldValue = this._properties;
        this._properties = properties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }

    public PropertyConfigBean[] getProperties() {
        return this._properties;
    }

    public PropertyConfigBean[] defaultProperties() {
        return new PropertyConfigBean[0];
    }

    public void addProperties() throws ConfigurationException {
        if (this._properties != null) {
            return;
        }
        PropertyConfigBean[] properties = new PropertyConfigBean[]{new PropertyConfigBean(this, null)};
        this.setProperties(properties);
    }

    public void removeProperties() throws ConfigurationException {
        if (this._properties == null) {
            return;
        }
        this.setProperties(null);
    }

    public void addProperty(PropertyConfigBean property) throws ConfigurationException {
        property.setParent(this);
        int existingPropertiesCnt = 0;
        if (this._properties != null) {
            existingPropertiesCnt = this._properties.length;
        }
        PropertyConfigBean[] newProperties = new PropertyConfigBean[existingPropertiesCnt + 1];
        for (int n = 0; n < existingPropertiesCnt; ++n) {
            newProperties[n] = this._properties[n];
        }
        newProperties[existingPropertiesCnt] = property;
        PropertyConfigBean[] oldValue = this._properties;
        this._properties = newProperties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }

    public void removeProperty(PropertyConfigBean property) throws ConfigurationException {
        int existingPropertiesCnt = 0;
        if (this._properties != null) {
            existingPropertiesCnt = this._properties.length;
        }
        PropertyConfigBean[] newProperties = new PropertyConfigBean[existingPropertiesCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingPropertiesCnt; ++n) {
            if (property.equals(this._properties[n])) continue;
            newProperties[newIndex++] = this._properties[n];
        }
        if (newProperties.length == 0) {
            newProperties = null;
        }
        PropertyConfigBean[] oldValue = this._properties;
        this._properties = newProperties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "decrypt");
        XMLUtils.writeTagAttributeEnd(out, indentation, "decrypt");
        if (this._encryptionMethods != null) {
            this._encryptionMethods.writeXML(out, indentation + "\t");
        }
        if (this._keyTransportMethods != null) {
            this._keyTransportMethods.writeXML(out, indentation + "\t");
        }
        if (this._tbeElements != null) {
            this._tbeElements.writeXML(out, indentation + "\t");
        }
        DecryptConfigType.writeXML(out, indentation + "\t", this._properties);
        XMLUtils.writeTagEnd(out, indentation, "decrypt");
    }

    private void init() throws ConfigurationException {
        this.setXpath("decrypt");
        Vector<PropertyConfigBean> properties = new Vector<PropertyConfigBean>();
        if (this.getNode() != null) {
            Object val = null;
            Node node = this.getNode();
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (name.equals("encryption-methods")) {
                    this.setEncryptionMethods(new EncryptionMethodsConfigType(this, node));
                    continue;
                }
                if (name.equals("keytransport-methods")) {
                    this.setKeyTransportMethods(new KeyTransportMethodsConfigType(this, node));
                    continue;
                }
                if (name.equals("tbe-elements")) {
                    this.setTbeElements(new EncryptElementsConfigType(this, node));
                    continue;
                }
                if (!name.equals("property")) continue;
                PropertyConfigBean configBean = new PropertyConfigBean(this, node);
                properties.add(configBean);
            }
        }
        if (properties.size() > 0) {
            this.setProperties(properties.toArray(new PropertyConfigBean[0]));
        }
    }
}

