/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EjbRefType
extends ConfigBeanNode {
    String description;
    String ejbRefName;
    String ejbRefType;
    String home;
    String remote;
    String ejbLink;

    public EjbRefType(ConfigBeanNode parent, Node node) {
        super(null, parent, node);
        this.init();
    }

    public void init() {
        this.setXpath("ejb-ref");
        Node node = this.getNode();
        if (node != null) {
            NodeList childNodes = node.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                String nodeName = childNodes.item(i).getNodeName();
                if (nodeName.equals("description")) {
                    this.description = XMLUtils.getValue(childNodes.item(i));
                    continue;
                }
                if (nodeName.equals("ejb-ref-name")) {
                    this.ejbRefName = XMLUtils.getValue(childNodes.item(i));
                    continue;
                }
                if (nodeName.equals("ejb-ref-type")) {
                    this.ejbRefType = XMLUtils.getValue(childNodes.item(i));
                    continue;
                }
                if (nodeName.equals("home")) {
                    this.home = XMLUtils.getValue(childNodes.item(i));
                    continue;
                }
                if (nodeName.equals("remote")) {
                    this.remote = XMLUtils.getValue(childNodes.item(i));
                    continue;
                }
                if (!nodeName.equals("ejb-link")) continue;
                this.ejbLink = XMLUtils.getValue(childNodes.item(i));
            }
        }
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagStart(out, indentation, "ejb-ref");
        XMLUtils.writeTagWithValue(out, indentation + "\t", "description", this.description);
        XMLUtils.writeTagWithValue(out, indentation + "\t", "ejb-ref-name", this.ejbRefName);
        XMLUtils.writeTagWithValue(out, indentation + "\t", "ejb-ref-type", this.ejbRefType);
        XMLUtils.writeTagWithValue(out, indentation + "\t", "home", this.home);
        XMLUtils.writeTagWithValue(out, indentation + "\t", "remote", this.remote);
        XMLUtils.writeTagWithValue(out, indentation + "\t", "ejb-link", this.ejbLink);
        XMLUtils.writeTagEnd(out, indentation, "ejb-ref");
    }

    public String getDescription() {
        return this.description;
    }

    public String getEjbLink() {
        return this.ejbLink;
    }

    public String getEjbRefName() {
        return this.ejbRefName;
    }

    public String getEjbRefType() {
        return this.ejbRefType;
    }

    public String getHome() {
        return this.home;
    }

    public String getRemote() {
        return this.remote;
    }
}

