/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.EncryptionMethodConfigType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EncryptionMethodsConfigType
extends ConfigBeanNode {
    EncryptionMethodConfigType[] _encryptionMethods = null;

    public EncryptionMethodsConfigType(ConfigBeanNode parent) throws ConfigurationException {
        this(parent, null);
    }

    public EncryptionMethodsConfigType(ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(null, parent, node);
        this.init();
    }

    public void setEncryptionMethods(EncryptionMethodConfigType[] encryptionMethods) throws ConfigurationException {
        EncryptionMethodConfigType[] oldValue = this._encryptionMethods;
        this._encryptionMethods = encryptionMethods;
        this.firePropertyChange("encryptionMethods", oldValue, this._encryptionMethods);
    }

    public EncryptionMethodConfigType[] getEncryptionMethods() {
        return this._encryptionMethods;
    }

    public EncryptionMethodConfigType[] defaultEncryptionMethods() {
        return new EncryptionMethodConfigType[0];
    }

    public void addEncryptionMethods() throws ConfigurationException {
        if (this._encryptionMethods != null) {
            return;
        }
        EncryptionMethodConfigType[] encryptionMethods = new EncryptionMethodConfigType[]{new EncryptionMethodConfigType(this)};
        this.setEncryptionMethods(encryptionMethods);
    }

    public void removeEncryptionMethods() throws ConfigurationException {
        if (this._encryptionMethods == null) {
            return;
        }
        this.setEncryptionMethods(null);
    }

    public void addEncryptionMethod(EncryptionMethodConfigType encryptionMethod) throws ConfigurationException {
        encryptionMethod.setParent(this);
        int existingEncryptionMethodsCnt = 0;
        if (this._encryptionMethods != null) {
            existingEncryptionMethodsCnt = this._encryptionMethods.length;
        }
        EncryptionMethodConfigType[] newEncryptionMethods = new EncryptionMethodConfigType[existingEncryptionMethodsCnt + 1];
        for (int n = 0; n < existingEncryptionMethodsCnt; ++n) {
            newEncryptionMethods[n] = this._encryptionMethods[n];
        }
        newEncryptionMethods[existingEncryptionMethodsCnt] = encryptionMethod;
        EncryptionMethodConfigType[] oldValue = this._encryptionMethods;
        this._encryptionMethods = newEncryptionMethods;
        this.firePropertyChange("encryptionMethods", oldValue, this._encryptionMethods);
    }

    public void removeEncryptionMethod(EncryptionMethodConfigType encryptionMethod) throws ConfigurationException {
        int existingEncryptionMethodsCnt = 0;
        if (this._encryptionMethods != null) {
            existingEncryptionMethodsCnt = this._encryptionMethods.length;
        }
        EncryptionMethodConfigType[] newEncryptionMethods = new EncryptionMethodConfigType[existingEncryptionMethodsCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingEncryptionMethodsCnt; ++n) {
            if (encryptionMethod.equals(this._encryptionMethods[n])) continue;
            newEncryptionMethods[newIndex++] = this._encryptionMethods[n];
        }
        if (newEncryptionMethods.length == 0) {
            newEncryptionMethods = null;
        }
        EncryptionMethodConfigType[] oldValue = this._encryptionMethods;
        this._encryptionMethods = newEncryptionMethods;
        this.firePropertyChange("encryptionMethods", oldValue, this._encryptionMethods);
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "encryption-methods");
        XMLUtils.writeTagAttributeEnd(out, indentation, "encryption-methods");
        EncryptionMethodsConfigType.writeXML(out, indentation + "\t", this._encryptionMethods);
        XMLUtils.writeTagEnd(out, indentation, "encryption-methods");
    }

    private void init() throws ConfigurationException {
        this.setXpath("encryption-methods");
        Vector<EncryptionMethodConfigType> encryptionMethods = new Vector<EncryptionMethodConfigType>();
        if (this.getNode() != null) {
            Object val = null;
            Node node = this.getNode();
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (!name.equals("encryption-method")) continue;
                EncryptionMethodConfigType configBean = new EncryptionMethodConfigType(this, node);
                encryptionMethods.add(configBean);
            }
        }
        if (encryptionMethods.size() > 0) {
            this.setEncryptionMethods(encryptionMethods.toArray(new EncryptionMethodConfigType[0]));
        }
    }
}

