/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.EncryptionMethodConfigType;
import oracle.oc4j.admin.deploy.spi.xml.EncryptionMethodTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.EncryptionMethodsConfigType;

public class EncryptionMethodsTreeNode
extends ConfigTreeNode
implements ActionListener {
    private EncryptionMethodsConfigType _bean;
    private static final String ADD_ENCRYPTION_METHOD_MENU_STRING = "Add Encryption Method";
    private static final String REMOVE_ENCRYPTION_METHODS_MENU_STRING = "Remove Encryption Methods";
    private JMenuItem _addEncryptionMethodMenuItem;
    private JMenuItem _removeEncryptionMethodsMenuItem;

    public EncryptionMethodsTreeNode(ConfigTreeNode rootNode, EncryptionMethodsConfigType encryptionMethods) {
        super(encryptionMethods);
        this.setRootNode(rootNode);
        this._bean = encryptionMethods;
        this._addEncryptionMethodMenuItem = new JMenuItem(ADD_ENCRYPTION_METHOD_MENU_STRING);
        this._addEncryptionMethodMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addEncryptionMethodMenuItem.setFont(EncryptionMethodsTreeNode.getFont());
        this._addEncryptionMethodMenuItem.addActionListener(this);
        this._removeEncryptionMethodsMenuItem = new JMenuItem(REMOVE_ENCRYPTION_METHODS_MENU_STRING);
        this._removeEncryptionMethodsMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._removeEncryptionMethodsMenuItem.setFont(EncryptionMethodsTreeNode.getFont());
        this._removeEncryptionMethodsMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addEncryptionMethodMenuItem);
        this._popup.add(this._removeEncryptionMethodsMenuItem);
    }

    public String viewHeaderString() {
        return "Encryption Methods";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        EncryptionMethodConfigType[] encryptionMethods = this._bean.getEncryptionMethods();
        if (encryptionMethods != null) {
            for (int i = 0; i < encryptionMethods.length; ++i) {
                EncryptionMethodConfigType encryptionMethod = encryptionMethods[i];
                if (encryptionMethod == null) continue;
                EncryptionMethodTreeNode encryptionMethodTreeNode = new EncryptionMethodTreeNode(this.getRootNode(), encryptionMethod);
                this.addChild(encryptionMethodTreeNode);
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(ADD_ENCRYPTION_METHOD_MENU_STRING)) {
                EncryptionMethodConfigType newEncryptionMethod = new EncryptionMethodConfigType(this._bean);
                if (this.showAddDialog(newEncryptionMethod, ADD_ENCRYPTION_METHOD_MENU_STRING)) {
                    this._bean.addEncryptionMethod(newEncryptionMethod);
                    EncryptionMethodTreeNode newNode = new EncryptionMethodTreeNode(this, newEncryptionMethod);
                    this.insertNode(newNode);
                }
            } else if (event.getActionCommand().equals(REMOVE_ENCRYPTION_METHODS_MENU_STRING) && this.confirmRemove()) {
                this.getParentNode().remove(this);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof EncryptionMethodTreeNode) {
            EncryptionMethodConfigType encryptionMethod = (EncryptionMethodConfigType)node.getConfigBeanNode();
            this._bean.removeEncryptionMethod(encryptionMethod);
            this.removeNode(node);
        }
    }
}

