/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EnvEntryType
extends ConfigBeanNode {
    String description;
    String envEntryName;
    String envEntryValue;
    String envEntryType;

    public EnvEntryType(ConfigBeanNode parent, Node node) {
        super(null, parent, node);
        this.init();
    }

    public void init() {
        this.setXpath("env-entry");
        Node node = this.getNode();
        if (node != null) {
            NodeList childNodes = node.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                String nodeName = childNodes.item(i).getNodeName();
                if (nodeName.equals("description")) {
                    this.description = XMLUtils.getValue(childNodes.item(i));
                    continue;
                }
                if (nodeName.equals("env-entry-name")) {
                    this.envEntryName = XMLUtils.getValue(childNodes.item(i));
                    continue;
                }
                if (nodeName.equals("env-entry-value")) {
                    this.envEntryValue = XMLUtils.getValue(childNodes.item(i));
                    continue;
                }
                if (!nodeName.equals("env-entry-type")) continue;
                this.envEntryType = XMLUtils.getValue(childNodes.item(i));
            }
        }
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagStart(out, indentation, "env-entry");
        XMLUtils.writeTagWithValue(out, indentation + "\t", "description", this.description);
        XMLUtils.writeTagWithValue(out, indentation + "\t", "env-entry-name", this.envEntryName);
        XMLUtils.writeTagWithValue(out, indentation + "\t", "env-entry-value", this.envEntryValue);
        XMLUtils.writeTagWithValue(out, indentation + "\t", "env-entry-type", this.envEntryType);
        XMLUtils.writeTagEnd(out, indentation, "env-entry");
    }

    public String getDescription() {
        return this.description;
    }

    public String getEnvEntryName() {
        return this.envEntryName;
    }

    public String getEnvEntryType() {
        return this.envEntryType;
    }

    public String getEnvEntryValue() {
        return this.envEntryValue;
    }
}

