/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.exceptions.ExtendedConfigurationException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.ExpirationSettingTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.ExpirationSettingType;
import oracle.oc4j.admin.deploy.spi.xml.MultipleType;

public class ExpirationSettingsTreeNode
extends ConfigTreeNode
implements ActionListener {
    private ConfigBeanNode _parentBean;
    private static final String ADD_EXPIRATION_SETTING_MENU_STRING = "Add Expiration Setting";
    private JMenuItem _addExpirationSettingMenuItem;
    private ExpirationSettingType[] expirationSettingsType = new ExpirationSettingType[0];
    private Method _readMethod = null;
    private Method _addMethod = null;
    private Method _removeMethod = null;

    public ExpirationSettingsTreeNode(ConfigTreeNode rootNode, MultipleType expirationSettings) {
        super(expirationSettings);
        this.setRootNode(rootNode);
        this._parentBean = expirationSettings.getConfigParent();
        this._addExpirationSettingMenuItem = new JMenuItem(ADD_EXPIRATION_SETTING_MENU_STRING);
        this._addExpirationSettingMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addExpirationSettingMenuItem.setFont(ExpirationSettingsTreeNode.getFont());
        this._addExpirationSettingMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addExpirationSettingMenuItem);
        Class<?> beanClass = this._parentBean.getClass();
        try {
            this._readMethod = beanClass.getMethod("getExpirationSettings", null);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._addMethod = beanClass.getMethod("addExpirationSetting", ExpirationSettingType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._removeMethod = beanClass.getMethod("removeExpirationSetting", ExpirationSettingType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public String viewHeaderString() {
        return "Expiration Settings";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        try {
            ExpirationSettingType[] expirationSettings = (ExpirationSettingType[])this._readMethod.invoke((Object)this._parentBean, null);
            if (expirationSettings != null) {
                for (int i = 0; i < expirationSettings.length; ++i) {
                    ExpirationSettingType expirationSetting = expirationSettings[i];
                    if (expirationSetting == null) continue;
                    ExpirationSettingTreeNode expirationSettingTreeNode = new ExpirationSettingTreeNode(this.getRootNode(), expirationSetting);
                    this.addChild(expirationSettingTreeNode);
                }
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            ExpirationSettingType newExpirationSetting;
            if (event.getActionCommand().equals(ADD_EXPIRATION_SETTING_MENU_STRING) && this.showAddDialog(newExpirationSetting = new ExpirationSettingType(this._parentBean), ADD_EXPIRATION_SETTING_MENU_STRING)) {
                this._addMethod.invoke((Object)this._parentBean, newExpirationSetting);
                ExpirationSettingTreeNode newNode = new ExpirationSettingTreeNode(this, newExpirationSetting);
                this.insertNode(newNode);
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof ExpirationSettingTreeNode) {
            try {
                ExpirationSettingType expirationSetting = (ExpirationSettingType)node.getConfigBeanNode();
                this._removeMethod.invoke((Object)this._parentBean, expirationSetting);
                this.removeNode(node);
            }
            catch (Throwable t) {
                throw new ExtendedConfigurationException(t);
            }
        }
    }
}

