/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.ArrayList;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.IconType;
import oracle.oc4j.admin.deploy.spi.xml.WebInitParamType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FilterType
extends ConfigBeanNode {
    IconType icon;
    String filterName;
    String displayName;
    String description;
    String filterClass;
    WebInitParamType[] initParams = null;

    public FilterType(ConfigBeanNode parent, Node node) {
        super(null, parent, node);
        this.init();
    }

    public void init() {
        this.setXpath("filter");
        ArrayList<WebInitParamType> initParamList = new ArrayList<WebInitParamType>();
        Node node = this.getNode();
        if (node != null) {
            NodeList childNodes = node.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (nodeName.equals("icon")) {
                    this.icon = new IconType(this, childNode);
                    continue;
                }
                if (nodeName.equals("filter-name")) {
                    this.filterName = XMLUtils.getValue(childNodes.item(i));
                    continue;
                }
                if (nodeName.equals("display-name")) {
                    this.displayName = XMLUtils.getValue(childNodes.item(i));
                    continue;
                }
                if (nodeName.equals("description")) {
                    this.description = XMLUtils.getValue(childNodes.item(i));
                    continue;
                }
                if (nodeName.equals("filter-class")) {
                    this.filterClass = XMLUtils.getValue(childNodes.item(i));
                    continue;
                }
                if (!nodeName.equals("init-param")) continue;
                initParamList.add(new WebInitParamType(this, childNode));
            }
        }
        if (!initParamList.isEmpty()) {
            this.initParams = initParamList.toArray(new WebInitParamType[0]);
        }
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagStart(out, indentation, "filter");
        if (this.icon != null) {
            this.icon.writeXML(out, indentation + "\t");
        }
        XMLUtils.writeTagWithValue(out, indentation + "\t", "filter-name", this.filterName);
        XMLUtils.writeTagWithValue(out, indentation + "\t", "display-name", this.displayName);
        XMLUtils.writeTagWithValue(out, indentation + "\t", "description", this.description);
        XMLUtils.writeTagWithValue(out, indentation + "\t", "filter-class", this.filterClass);
        FilterType.writeXML(out, indentation + "\t", this.getInitParams());
        XMLUtils.writeTagEnd(out, indentation, "filter");
    }

    public IconType getIcon() {
        return this.icon;
    }

    public String getFilterName() {
        return this.filterName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getFilterClass() {
        return this.filterClass;
    }

    public WebInitParamType[] getInitParams() {
        return this.initParams;
    }
}

