/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.StringType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HostAccessType
extends ConfigBeanNode {
    StringType _mode = null;
    StringType _oldMode = null;
    String _domain = null;

    public HostAccessType(ConfigBeanNode parent) throws ConfigurationException {
        this(parent, null);
    }

    public HostAccessType(ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(null, parent, node);
        this.init();
    }

    public void setDomain(String domain) throws ConfigurationException {
        String oldValue = this._domain;
        this._domain = domain;
        this.firePropertyChange("domain", oldValue, this._domain);
    }

    public String getDomain() {
        return this._domain;
    }

    public String defaultDomain() {
        return "";
    }

    public void setMode(StringType mode) throws ConfigurationException {
        this._mode = mode;
        this.firePropertyChange("mode", this._oldMode, this._mode);
        if (this._mode != null) {
            if (this._oldMode == null) {
                this._oldMode = this.defaultMode();
            }
            this._oldMode.setValue(this._mode.getValue());
        } else {
            this._oldMode = null;
        }
    }

    public StringType getMode() {
        return this._mode;
    }

    public StringType defaultMode() {
        String[] tags = new String[]{"deny", "allow"};
        return new StringType(this, tags, "allow");
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "host-access");
        XMLUtils.writeAttribute(out, indentation, "domain", this._domain);
        XMLUtils.writeAttribute(out, indentation, "mode", this._mode);
        XMLUtils.writeTagAttributeEnd(out, indentation, "host-access");
        XMLUtils.writeTagEnd(out, indentation, "host-access");
    }

    public static void writeXML(PrintWriter out, String indentation, HostAccessType[] hostAccess) throws ExtendedRuntimeException {
        if (hostAccess == null) {
            return;
        }
        for (int n = 0; n < hostAccess.length; ++n) {
            hostAccess[n].writeXML(out, indentation);
        }
    }

    private void init() throws ConfigurationException {
        this.setXpath("host-access");
        if (this.getNode() != null) {
            String val = null;
            Node node = this.getNode();
            val = XMLUtils.getAttribute(node, "domain");
            if (val != null && !val.trim().equals("")) {
                this.setDomain(val);
            }
            if ((val = XMLUtils.getAttribute(node, "mode")) != null && !val.trim().equals("")) {
                StringType mode = this.defaultMode();
                mode.setValue(val);
                this.setMode(mode);
            }
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
            }
        }
    }
}

