/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.AttributeType;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JmxMBeanType
extends ConfigBeanNode {
    String _description = null;
    String _objectName = null;
    String _className = null;
    AttributeType[] _attributes = null;

    public JmxMBeanType(ConfigBeanNode parent) throws ConfigurationException {
        this(parent, null);
    }

    public JmxMBeanType(ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(null, parent, node);
        this.init();
    }

    public void setDescription(String description) throws ConfigurationException {
        String oldValue = this._description;
        this._description = description;
        this.firePropertyChange("description", oldValue, this._description);
    }

    public String getDescription() {
        return this._description;
    }

    public String defaultDescription() {
        return "";
    }

    public void setObjectName(String objectName) throws ConfigurationException {
        String oldValue = this._objectName;
        this._objectName = objectName;
        this.firePropertyChange("objectName", oldValue, this._objectName);
    }

    public String getObjectName() {
        return this._objectName;
    }

    public String defaultObjectName() {
        return "";
    }

    public void setClassName(String className) throws ConfigurationException {
        String oldValue = this._className;
        this._className = className;
        this.firePropertyChange("className", oldValue, this._className);
    }

    public String getClassName() {
        return this._className;
    }

    public String defaultClassName() {
        return "";
    }

    public void setAttributes(AttributeType[] attributes) {
        this._attributes = attributes;
    }

    public AttributeType[] getAttributes() {
        return this._attributes;
    }

    public AttributeType[] defaultAttributes() {
        return new AttributeType[0];
    }

    public void addAttributes() throws ConfigurationException {
        if (this._attributes != null) {
            return;
        }
        AttributeType[] attributes = new AttributeType[]{new AttributeType(this, null)};
        this.setAttributes(attributes);
    }

    public void removeAttributes() {
        if (this._attributes == null) {
            return;
        }
        this.setAttributes(null);
    }

    public void addAttribute(AttributeType attribute) {
        attribute.setParent(this);
        int existingAttributesCnt = 0;
        if (this._attributes != null) {
            existingAttributesCnt = this._attributes.length;
        }
        AttributeType[] newAttributes = new AttributeType[existingAttributesCnt + 1];
        for (int n = 0; n < existingAttributesCnt; ++n) {
            newAttributes[n] = this._attributes[n];
        }
        newAttributes[existingAttributesCnt] = attribute;
        AttributeType[] oldValue = this._attributes;
        this._attributes = newAttributes;
        this.firePropertyChange("attributes", oldValue, this._attributes);
    }

    public void removeAttribute(AttributeType attribute) {
        int existingAttributesCnt = 0;
        if (this._attributes != null) {
            existingAttributesCnt = this._attributes.length;
        }
        AttributeType[] newAttributes = new AttributeType[existingAttributesCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingAttributesCnt; ++n) {
            if (attribute.equals(this._attributes[n])) continue;
            newAttributes[newIndex++] = this._attributes[n];
        }
        AttributeType[] oldValue = this._attributes;
        this._attributes = newAttributes;
        this.firePropertyChange("attributes", oldValue, this._attributes);
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "jmx-mbean");
        XMLUtils.writeAttribute(out, indentation, "objectname", this._objectName);
        XMLUtils.writeAttribute(out, indentation, "class", this._className);
        XMLUtils.writeTagAttributeEnd(out, indentation, "jmx-mbean");
        if (this._description != null && this._description.length() > 0) {
            XMLUtils.writeTag(out, indentation + "\t", "description", this._description);
        }
        JmxMBeanType.writeXML(out, indentation + "\t", this._attributes);
        XMLUtils.writeTagEnd(out, indentation, "jmx-mbean");
    }

    public void writeAttributesXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        AttributeType.writeXML(out, indentation, this._attributes);
    }

    private void init() throws ConfigurationException {
        this.setXpath("jmx-mbean");
        Vector properties = new Vector();
        Vector<AttributeType> attributes = new Vector<AttributeType>();
        if (this.getNode() != null) {
            String val = null;
            Node node = this.getNode();
            val = XMLUtils.getAttribute(node, "objectname");
            if (val != null && !val.trim().equals("")) {
                this.setObjectName(val);
            }
            if ((val = XMLUtils.getAttribute(node, "class")) != null && !val.trim().equals("")) {
                this.setClassName(val);
            }
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (name.equals("description")) {
                    this.setDescription(XMLUtils.getValue(node));
                    continue;
                }
                if (!name.equals("attribute")) continue;
                AttributeType configBean = new AttributeType(this, node);
                attributes.add(configBean);
            }
        }
        if (attributes.size() > 0) {
            this._attributes = attributes.toArray(new AttributeType[0]);
        }
    }
}

