/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import javax.enterprise.deploy.model.DDBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LocaleEncodingMappingType
extends ConfigBeanNode {
    String locale;
    String encoding;

    public LocaleEncodingMappingType(ConfigBeanNode parent, Node node) {
        this(null, parent, node);
    }

    public LocaleEncodingMappingType(DDBean stdBean, ConfigBeanNode parent, Node node) {
        super(stdBean, parent, node);
        this.init();
    }

    public void init() {
        this.setXpath("locale-encoding-mapping");
        Node node = this.getNode();
        if (node != null) {
            NodeList childNodes = node.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                String nodeName = childNodes.item(i).getNodeName();
                if (nodeName.equals("locale")) {
                    this.locale = XMLUtils.getValue(childNodes.item(i));
                    continue;
                }
                if (!nodeName.equals("encoding")) continue;
                this.encoding = XMLUtils.getValue(childNodes.item(i));
            }
        }
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagStart(out, indentation, "locale-encoding-mapping");
        XMLUtils.writeTagWithValue(out, indentation, "locale", this.locale);
        XMLUtils.writeTagWithValue(out, indentation, "encoding", this.encoding);
        XMLUtils.writeTagEnd(out, indentation, "locale-encoding-mapping");
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }
}

