/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.FileTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.FileType;
import oracle.oc4j.admin.deploy.spi.xml.LogType;
import oracle.oc4j.admin.deploy.spi.xml.MailTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.MailType;
import oracle.oc4j.admin.deploy.spi.xml.OdlTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.OdlType;

public class LogTreeNode
extends ConfigTreeNode
implements ActionListener {
    private LogType _bean;
    private static final String ADD_FILE_MENU_STRING = "Add File";
    private static final String ADD_MAIL_MENU_STRING = "Add Mail";
    private static final String ADD_ODL_MENU_STRING = "Add Odl";
    private static final String REMOVE_LOG_MENU_STRING = "Remove Log";
    private JMenuItem _removeLogMenuItem;
    private JMenuItem _addFileMenuItem;
    private JMenuItem _addMailMenuItem;
    private JMenuItem _addOdlMenuItem;

    public LogTreeNode(ConfigTreeNode rootNode, LogType bean) {
        super(bean);
        this.setRootNode(rootNode);
        this._bean = bean;
        this._addFileMenuItem = new JMenuItem(ADD_FILE_MENU_STRING);
        this._addFileMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addFileMenuItem.setFont(LogTreeNode.getFont());
        this._addFileMenuItem.addActionListener(this);
        this._addMailMenuItem = new JMenuItem(ADD_MAIL_MENU_STRING);
        this._addMailMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addMailMenuItem.setFont(LogTreeNode.getFont());
        this._addMailMenuItem.addActionListener(this);
        this._addOdlMenuItem = new JMenuItem(ADD_ODL_MENU_STRING);
        this._addOdlMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addOdlMenuItem.setFont(LogTreeNode.getFont());
        this._addOdlMenuItem.addActionListener(this);
        this._removeLogMenuItem = new JMenuItem(REMOVE_LOG_MENU_STRING);
        this._removeLogMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._removeLogMenuItem.setFont(LogTreeNode.getFont());
        this._removeLogMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addFileMenuItem);
        this._popup.add(this._addMailMenuItem);
        this._popup.add(this._addOdlMenuItem);
        this._popup.add(this._removeLogMenuItem);
    }

    public String viewHeaderString() {
        return "Log";
    }

    public String toString() {
        return "Log";
    }

    protected void buildChildJTree() {
        OdlType[] odls;
        MailType[] mails;
        FileType[] files = this._bean.getFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                FileType file = files[i];
                if (file == null) continue;
                FileTreeNode fileTreeNode = new FileTreeNode(this.getRootNode(), file);
                this.addChild(fileTreeNode);
            }
        }
        if ((mails = this._bean.getMail()) != null) {
            for (int i = 0; i < mails.length; ++i) {
                MailType mail = mails[i];
                if (mail == null) continue;
                MailTreeNode mailTreeNode = new MailTreeNode(this.getRootNode(), mail);
                this.addChild(mailTreeNode);
            }
        }
        if ((odls = this._bean.getOdls()) != null) {
            for (int i = 0; i < odls.length; ++i) {
                OdlType odl = odls[i];
                if (odl == null) continue;
                OdlTreeNode odlTreeNode = new OdlTreeNode(this.getRootNode(), odl);
                this.addChild(odlTreeNode);
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            OdlType newOdl;
            MailType newMail;
            ConfigTreeNode newNode;
            FileType newFile;
            if (event.getActionCommand().equals(ADD_FILE_MENU_STRING) && this.showAddDialog(newFile = new FileType(this._bean), ADD_FILE_MENU_STRING)) {
                this._bean.addFile(newFile);
                newNode = new FileTreeNode(this, newFile);
                this.insertNode(newNode);
            }
            if (event.getActionCommand().equals(ADD_MAIL_MENU_STRING) && this.showAddDialog(newMail = new MailType(this._bean), ADD_MAIL_MENU_STRING)) {
                this._bean.addMail(newMail);
                newNode = new MailTreeNode(this, newMail);
                this.insertNode(newNode);
            }
            if (event.getActionCommand().equals(ADD_ODL_MENU_STRING) && this.showAddDialog(newOdl = new OdlType(this._bean), ADD_ODL_MENU_STRING)) {
                this._bean.addOdl(newOdl);
                newNode = new OdlTreeNode(this, newOdl);
                this.insertNode(newNode);
            }
            if (event.getActionCommand().equals(REMOVE_LOG_MENU_STRING) && this.confirmRemove()) {
                this.getParentNode().remove(this);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof FileTreeNode) {
            FileType file = (FileType)node.getConfigBeanNode();
            this._bean.removeFile(file);
            this.removeNode(node);
        }
        if (node instanceof MailTreeNode) {
            MailType mail = (MailType)node.getConfigBeanNode();
            this._bean.removeMail(mail);
            this.removeNode(node);
        }
        if (node instanceof OdlTreeNode) {
            OdlType odl = (OdlType)node.getConfigBeanNode();
            this._bean.removeOdl(odl);
            this.removeNode(node);
        }
    }
}

