/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.LoggingAttributeType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LoggingMessageType
extends ConfigBeanNode {
    String _myXpath = null;
    String _enabled = null;
    LoggingAttributeType[] _attributes = null;

    public LoggingMessageType(ConfigBeanNode parent, String xpath) {
        this(parent, xpath, null);
    }

    public LoggingMessageType(ConfigBeanNode parent, String xpath, Node node) {
        super(null, parent, node);
        this.setXpath(xpath);
        this._myXpath = xpath;
        this.init();
    }

    public void setEnabled(String enabled) throws ConfigurationException {
        String oldValue = this._enabled;
        this._enabled = enabled;
        this.firePropertyChange("enabled", oldValue, this._enabled);
    }

    public String getEnabled() {
        return this._enabled;
    }

    public String defaultEnabled() {
        return "";
    }

    public void setAttributes(LoggingAttributeType[] attributes) {
        this._attributes = attributes;
    }

    public LoggingAttributeType[] getAttributes() {
        return this._attributes;
    }

    public LoggingAttributeType[] defaultAttributes() {
        return new LoggingAttributeType[0];
    }

    public void addAttributes() throws ConfigurationException {
        if (this._attributes != null) {
            return;
        }
        LoggingAttributeType[] attributes = new LoggingAttributeType[]{new LoggingAttributeType(this, null)};
        this.setAttributes(attributes);
    }

    public void removeAttributes() {
        if (this._attributes == null) {
            return;
        }
        this.setAttributes(null);
    }

    public void addAttribute(LoggingAttributeType attribute) {
        attribute.setParent(this);
        int existingAttributesCnt = 0;
        if (this._attributes != null) {
            existingAttributesCnt = this._attributes.length;
        }
        LoggingAttributeType[] newAttributes = new LoggingAttributeType[existingAttributesCnt + 1];
        for (int n = 0; n < existingAttributesCnt; ++n) {
            newAttributes[n] = this._attributes[n];
        }
        newAttributes[existingAttributesCnt] = attribute;
        LoggingAttributeType[] oldValue = this._attributes;
        this._attributes = newAttributes;
        this.firePropertyChange("attributes", oldValue, this._attributes);
    }

    public void removeAttribute(LoggingAttributeType attribute) {
        int existingAttributesCnt = 0;
        if (this._attributes != null) {
            existingAttributesCnt = this._attributes.length;
        }
        LoggingAttributeType[] newAttributes = new LoggingAttributeType[existingAttributesCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingAttributesCnt; ++n) {
            if (attribute.equals(this._attributes[n])) continue;
            newAttributes[newIndex++] = this._attributes[n];
        }
        if (newAttributes.length == 0) {
            newAttributes = null;
        }
        LoggingAttributeType[] oldValue = this._attributes;
        this._attributes = newAttributes;
        this.firePropertyChange("attributes", oldValue, this._attributes);
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, this._myXpath);
        XMLUtils.writeAttribute(out, indentation, "enabled", this._enabled);
        XMLUtils.writeTagAttributeEnd(out, indentation, this._myXpath);
        this.writeAttributesXML(out, indentation + "\t");
        XMLUtils.writeTagEnd(out, indentation, this._myXpath);
    }

    public void writeAttributesXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        if (this._attributes != null) {
            XMLUtils.writeTagStart(out, indentation, "attributes");
            LoggingMessageType.writeXML(out, indentation + "\t", this._attributes);
            XMLUtils.writeTagEnd(out, indentation, "attributes");
        }
    }

    private void init() {
        Vector<LoggingAttributeType> attributes = new Vector<LoggingAttributeType>();
        if (this.getNode() != null) {
            String val = null;
            Node node = this.getNode();
            val = XMLUtils.getAttribute(node, "enabled");
            if (val != null && !val.trim().equals("")) {
                this._enabled = val;
            }
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (!name.equals("attributes")) continue;
                NodeList attributeNodes = node.getChildNodes();
                for (int op = 0; op < attributeNodes.getLength(); ++op) {
                    node = attributeNodes.item(op);
                    name = node.getNodeName();
                    if (!name.equals("attribute")) continue;
                    LoggingAttributeType configBean = new LoggingAttributeType(this, node);
                    attributes.add(configBean);
                }
            }
        }
        if (attributes.size() > 0) {
            this._attributes = attributes.toArray(new LoggingAttributeType[0]);
        }
    }
}

