/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.FormLoginConfigType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LoginConfigType
extends ConfigBeanNode {
    String authMethod;
    String realmName;
    FormLoginConfigType formLoginConfig = null;

    public LoginConfigType(ConfigBeanNode parent, Node node) {
        super(null, parent, node);
        this.init();
    }

    public void init() {
        this.setXpath("security-role-ref");
        Node node = this.getNode();
        if (node != null) {
            NodeList childNodes = node.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                String nodeName = childNodes.item(i).getNodeName();
                if (nodeName.equals("auth-method")) {
                    this.authMethod = XMLUtils.getValue(childNodes.item(i));
                    continue;
                }
                if (nodeName.equals("realm-name")) {
                    this.realmName = XMLUtils.getValue(childNodes.item(i));
                    continue;
                }
                if (!nodeName.equals("form-login-config")) continue;
                this.formLoginConfig = new FormLoginConfigType(this, childNodes.item(i));
            }
        }
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagStart(out, indentation, "login-config");
        XMLUtils.writeTagWithValue(out, indentation + "\t", "auth-method", this.authMethod);
        XMLUtils.writeTagWithValue(out, indentation + "\t", "realm-name", this.realmName);
        if (this.formLoginConfig != null) {
            this.formLoginConfig.writeXML(out, indentation);
        }
        XMLUtils.writeTagEnd(out, indentation, "login-config");
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public FormLoginConfigType getFormLoginConfig() {
        return this.formLoginConfig;
    }

    public String getRealmName() {
        return this.realmName;
    }
}

