/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.tree.TreePath;
import oracle.oc4j.admin.deploy.gui.ViewableJTree;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTree;
import oracle.oc4j.admin.deploy.spi.xml.JmsQueueLocationMappingType;
import oracle.oc4j.admin.deploy.spi.xml.JmsTopicLocationMappingType;
import oracle.oc4j.admin.deploy.spi.xml.LocationMappingType;
import oracle.oc4j.admin.deploy.spi.xml.MessageDestinationRefMappingTreeNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MessageDestinationRefMappingType
extends ConfigBeanNode {
    String _name = null;
    LocationMappingType _locationMapping = null;

    public MessageDestinationRefMappingType(DDBean stdBean, ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(stdBean, parent, node);
        this.init();
    }

    public MessageDestinationRefMappingType(ConfigBeanNode parent, Node node) throws ConfigurationException {
        this(null, parent, node);
    }

    public void putDDBean(DDBean bean) {
        super.putDDBean(bean);
        DDBean[] childBeans = bean.getChildBean("message-destination-type");
        if (childBeans != null && childBeans[0] != null) {
            String text = childBeans[0].getText();
            String loc = this._locationMapping.getLocation();
            if ("javax.jms.Topic".equals(text)) {
                this._locationMapping = new JmsTopicLocationMappingType(this);
                this._locationMapping.setLocation(loc);
            } else if ("javax.jms.Queue".equals(text)) {
                this._locationMapping = new JmsQueueLocationMappingType(this);
                this._locationMapping.setLocation(loc);
            }
        }
    }

    public LocationMappingType getLocationMapping() {
        return this._locationMapping;
    }

    public LocationMappingType defaultLocationMapping() {
        return new LocationMappingType(this);
    }

    public String getName() {
        return this._name;
    }

    public String defaultName() {
        if (this._name != null) {
            return this._name;
        }
        return "";
    }

    public String key() {
        return this.getName();
    }

    public String beanKey() {
        return "message-destination-ref-name";
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "message-destination-ref-mapping");
        XMLUtils.writeAttribute(out, indentation, "location", this._locationMapping.getLocation());
        XMLUtils.writeAttribute(out, indentation, "name", this._name);
        XMLUtils.writeTagAttributeEnd(out, indentation, "message-destination-ref-mapping");
        XMLUtils.writeTagEnd(out, indentation, "message-destination-ref-mapping");
    }

    protected void init() throws ConfigurationException {
        DDBean[] childBeans;
        this.setXpath("message-destination-ref-mapping");
        DDBean bean = this.getDDBean();
        if (bean != null && (childBeans = bean.getChildBean("message-destination-type")) != null && childBeans[0] != null) {
            String text = childBeans[0].getText();
            if ("javax.jms.Topic".equals(text)) {
                this._locationMapping = new JmsTopicLocationMappingType(this);
            } else if ("javax.jms.Queue".equals(text)) {
                this._locationMapping = new JmsQueueLocationMappingType(this);
            }
        }
        if (this._locationMapping == null) {
            this._locationMapping = new LocationMappingType(this);
        }
        if (this.getNode() != null) {
            String val = null;
            Node node = this.getNode();
            val = XMLUtils.getAttribute(node, "name");
            if (val != null && !val.trim().equals("")) {
                this._name = val;
            }
            if ((val = XMLUtils.getAttribute(this.getNode(), "location")) != null && !val.trim().equals("")) {
                this._locationMapping.setLocation(val);
            }
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
            }
        } else if (this.getDDBean() != null && this.getDDBean().getText(this.beanKey()) != null) {
            this._name = this.getDDBean().getText(this.beanKey())[0];
        }
    }

    public ViewableJTree[] subTrees() {
        MessageDestinationRefMappingTreeNode treeNode = new MessageDestinationRefMappingTreeNode(this);
        treeNode.setTreePath(new TreePath(treeNode));
        ConfigTree tree = new ConfigTree(treeNode);
        treeNode.setTree(tree);
        return new ViewableJTree[]{tree};
    }
}

