/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.exceptions.ExtendedConfigurationException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.MimeMappingTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.MimeMappingsType;
import oracle.oc4j.admin.deploy.spi.xml.MultipleType;

public class MimeMappingsTreeNode
extends ConfigTreeNode
implements ActionListener {
    private ConfigBeanNode _parentBean;
    private static final String ADD_MIME_MAPPING_MENU_STRING = "Add Mime Mapping";
    private JMenuItem _addMimeMappingMenuItem;
    private MimeMappingsType[] mimeMappingsType = new MimeMappingsType[0];
    private Method _readMethod = null;
    private Method _addMethod = null;
    private Method _removeMethod = null;

    public MimeMappingsTreeNode(ConfigTreeNode rootNode, MultipleType mimeMappings) {
        super(mimeMappings);
        this.setRootNode(rootNode);
        this._parentBean = mimeMappings.getConfigParent();
        this._addMimeMappingMenuItem = new JMenuItem(ADD_MIME_MAPPING_MENU_STRING);
        this._addMimeMappingMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addMimeMappingMenuItem.setFont(MimeMappingsTreeNode.getFont());
        this._addMimeMappingMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addMimeMappingMenuItem);
        Class<?> beanClass = this._parentBean.getClass();
        try {
            this._readMethod = beanClass.getMethod("getMimeMappings", null);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._addMethod = beanClass.getMethod("addMimeMapping", MimeMappingsType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._removeMethod = beanClass.getMethod("removeMimeMapping", MimeMappingsType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public String viewHeaderString() {
        return "Mime Mappings";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        try {
            MimeMappingsType[] mimeMappings = (MimeMappingsType[])this._readMethod.invoke((Object)this._parentBean, null);
            if (mimeMappings != null) {
                for (int i = 0; i < mimeMappings.length; ++i) {
                    MimeMappingsType mimeMapping = mimeMappings[i];
                    if (mimeMapping == null) continue;
                    MimeMappingTreeNode mimeMappingTreeNode = new MimeMappingTreeNode(this.getRootNode(), mimeMapping);
                    this.addChild(mimeMappingTreeNode);
                }
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            MimeMappingsType newMimeMapping;
            if (event.getActionCommand().equals(ADD_MIME_MAPPING_MENU_STRING) && this.showAddDialog(newMimeMapping = new MimeMappingsType(this._parentBean), ADD_MIME_MAPPING_MENU_STRING)) {
                this._addMethod.invoke((Object)this._parentBean, newMimeMapping);
                MimeMappingTreeNode newNode = new MimeMappingTreeNode(this, newMimeMapping);
                this.insertNode(newNode);
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof MimeMappingTreeNode) {
            try {
                MimeMappingsType mimeMapping = (MimeMappingsType)node.getConfigBeanNode();
                this._removeMethod.invoke((Object)this._parentBean, mimeMapping);
                this.removeNode(node);
            }
            catch (Throwable t) {
                throw new ExtendedConfigurationException(t);
            }
        }
    }
}

