/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.IntegerType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MulticastType
extends ConfigBeanNode {
    protected String _ip = null;
    IntegerType _port = null;
    IntegerType _oldPort = null;
    protected String _bindAddr = null;

    public MulticastType(ConfigBeanNode parent) throws ConfigurationException {
        this(parent, null);
    }

    public MulticastType(ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(null, parent, node);
        this.init();
    }

    public void setIp(String ip) throws ConfigurationException {
        String oldValue = this._ip;
        this._ip = ip;
        this.firePropertyChange("ip", oldValue, this._ip);
    }

    public String getIp() {
        return this._ip;
    }

    public String defaultIp() {
        return "230.230.0.1";
    }

    public void setPort(IntegerType port) throws ConfigurationException {
        this._port = port;
        this.firePropertyChange("port", this._oldPort, this._port);
        if (this._port != null) {
            if (this._oldPort == null) {
                this._oldPort = this.defaultPort();
            }
            this._oldPort.setValue(this._port.getValue());
        } else {
            this._oldPort = null;
        }
    }

    public IntegerType getPort() {
        return this._port;
    }

    public IntegerType defaultPort() {
        try {
            return new IntegerType(this, "45566");
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void setBindAddr(String bindAddr) throws ConfigurationException {
        String oldValue = this._bindAddr;
        this._bindAddr = bindAddr;
        this.firePropertyChange("bindAddr", oldValue, this._bindAddr);
    }

    public String getBindAddr() {
        return this._bindAddr;
    }

    public String defaultBindAddr() {
        return "";
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "multicast");
        if (this._ip != null && this._ip.length() > 0) {
            XMLUtils.writeAttribute(out, indentation + "\t", "ip", this._ip);
        }
        XMLUtils.writeAttribute(out, indentation, "port", this._port);
        if (this._bindAddr != null && this._bindAddr.length() > 0) {
            XMLUtils.writeAttribute(out, indentation + "\t", "bind_addr", this._bindAddr);
        }
        XMLUtils.writeTagAttributeEnd(out, indentation, "multicast");
        XMLUtils.writeTagEnd(out, indentation, "multicast");
    }

    private void init() throws ConfigurationException {
        this.setXpath("multicast");
        if (this.getNode() != null) {
            String val = null;
            Node node = this.getNode();
            val = XMLUtils.getAttribute(node, "ip");
            if (val != null && !val.trim().equals("")) {
                this._ip = val;
            }
            if ((val = XMLUtils.getAttribute(node, "port")) != null && !val.trim().equals("")) {
                IntegerType port = this.defaultPort();
                port.setValue(val);
                this.setPort(port);
            }
            if ((val = XMLUtils.getAttribute(node, "bind_addr")) != null && !val.trim().equals("")) {
                this._bindAddr = val;
            }
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
            }
        }
    }
}

