/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.exceptions.ExtendedConfigurationException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.MultipleType;
import oracle.oc4j.admin.deploy.spi.xml.OptionTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.OptionType;

public class OptionsTreeNode
extends ConfigTreeNode
implements ActionListener {
    private ConfigBeanNode _parentBean;
    private static final String ADD_OPTION_MENU_STRING = "Add Option";
    private JMenuItem _addOptionMenuItem;
    private OptionType[] optionsType = new OptionType[0];
    private Method _readMethod = null;
    private Method _addMethod = null;
    private Method _removeMethod = null;

    public OptionsTreeNode(ConfigTreeNode rootNode, MultipleType options) {
        super(options);
        this.setRootNode(rootNode);
        this._parentBean = options.getConfigParent();
        this._addOptionMenuItem = new JMenuItem(ADD_OPTION_MENU_STRING);
        this._addOptionMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addOptionMenuItem.setFont(OptionsTreeNode.getFont());
        this._addOptionMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addOptionMenuItem);
        Class<?> beanClass = this._parentBean.getClass();
        try {
            this._readMethod = beanClass.getMethod("getOptions", null);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._addMethod = beanClass.getMethod("addOption", OptionType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._removeMethod = beanClass.getMethod("removeOption", OptionType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public String viewHeaderString() {
        return "Options";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        try {
            OptionType[] options = (OptionType[])this._readMethod.invoke((Object)this._parentBean, null);
            if (options != null) {
                for (int i = 0; i < options.length; ++i) {
                    OptionType option = options[i];
                    if (option == null) continue;
                    OptionTreeNode optionTreeNode = new OptionTreeNode(this.getRootNode(), option);
                    this.addChild(optionTreeNode);
                }
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            OptionType newOption;
            if (event.getActionCommand().equals(ADD_OPTION_MENU_STRING) && this.showAddDialog(newOption = new OptionType(this._parentBean), ADD_OPTION_MENU_STRING)) {
                this._addMethod.invoke((Object)this._parentBean, newOption);
                OptionTreeNode newNode = new OptionTreeNode(this, newOption);
                this.insertNode(newNode);
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof OptionTreeNode) {
            try {
                OptionType option = (OptionType)node.getConfigBeanNode();
                this._removeMethod.invoke((Object)this._parentBean, option);
                this.removeNode(node);
            }
            catch (Throwable t) {
                throw new ExtendedConfigurationException(t);
            }
        }
    }
}

