/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.CallPropertiesTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.ClientOperationsTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.ClientPortRuntimeTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.ClientPortRuntimeType;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.MultipleType;
import oracle.oc4j.admin.deploy.spi.xml.PortInfoType;
import oracle.oc4j.admin.deploy.spi.xml.StubPropertiesTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.WsdlPortTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.WsdlPortType;

public class PortInfoTreeNode
extends ConfigTreeNode
implements ActionListener {
    private PortInfoType _bean;
    private static final String ADD_WSDL_PORT_MENU_STRING = "Add Wsdl Port";
    private static final String ADD_RUNTIME_MENU_STRING = "Add Runtime";
    private static final String REMOVE_PORT_INFO_MENU_STRING = "Remove Port Info";
    private JMenuItem _addWsdlPortMenuItem;
    private JMenuItem _addRuntimeMenuItem;
    private JMenuItem _removePortInfoMenuItem;

    public PortInfoTreeNode(ConfigTreeNode rootNode, PortInfoType portInfo) {
        super(portInfo);
        this.setRootNode(rootNode);
        this._bean = portInfo;
        this._addWsdlPortMenuItem = new JMenuItem(ADD_WSDL_PORT_MENU_STRING);
        this._addWsdlPortMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addWsdlPortMenuItem.setFont(PortInfoTreeNode.getFont());
        this._addWsdlPortMenuItem.addActionListener(this);
        if (this._bean.getWsdlPort() != null) {
            this._addWsdlPortMenuItem.setEnabled(false);
        }
        this._addRuntimeMenuItem = new JMenuItem(ADD_RUNTIME_MENU_STRING);
        this._addRuntimeMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addRuntimeMenuItem.setFont(PortInfoTreeNode.getFont());
        this._addRuntimeMenuItem.addActionListener(this);
        if (this._bean.getRuntime() != null) {
            this._addRuntimeMenuItem.setEnabled(false);
        }
        this._removePortInfoMenuItem = new JMenuItem(REMOVE_PORT_INFO_MENU_STRING);
        this._removePortInfoMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._removePortInfoMenuItem.setFont(PortInfoTreeNode.getFont());
        this._removePortInfoMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addWsdlPortMenuItem);
        this._popup.add(this._addRuntimeMenuItem);
        this._popup.add(this._removePortInfoMenuItem);
    }

    public String viewHeaderString() {
        return "Port Info";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        Method xmlMethod;
        WsdlPortType wsdlPort = this._bean.getWsdlPort();
        if (wsdlPort != null) {
            WsdlPortTreeNode wsdlPortTreeNode = new WsdlPortTreeNode(this.getRootNode(), wsdlPort);
            this.addChild(wsdlPortTreeNode);
        }
        try {
            xmlMethod = PortInfoType.class.getMethod("writeCallPropertiesXML", PrintWriter.class, String.class);
            CallPropertiesTreeNode callPropertiesTreeNode = new CallPropertiesTreeNode(this.getRootNode(), new MultipleType(this._bean, xmlMethod));
            this.addChild(callPropertiesTreeNode);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
        try {
            xmlMethod = PortInfoType.class.getMethod("writeStubPropertiesXML", PrintWriter.class, String.class);
            StubPropertiesTreeNode stubPropertiesTreeNode = new StubPropertiesTreeNode(this.getRootNode(), new MultipleType(this._bean, xmlMethod));
            this.addChild(stubPropertiesTreeNode);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
        ClientPortRuntimeType runtime = this._bean.getRuntime();
        if (runtime != null) {
            ClientPortRuntimeTreeNode clientPortRuntimeTreeNode = new ClientPortRuntimeTreeNode(this.getRootNode(), runtime);
            this.addChild(clientPortRuntimeTreeNode);
        }
        try {
            Method xmlMethod2 = PortInfoType.class.getMethod("writeClientOperationsXML", PrintWriter.class, String.class);
            ClientOperationsTreeNode clientOperationsTreeNode = new ClientOperationsTreeNode(this.getRootNode(), new MultipleType(this._bean, xmlMethod2));
            this.addChild(clientOperationsTreeNode);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(ADD_WSDL_PORT_MENU_STRING)) {
                WsdlPortType newWsdlPort = this._bean.defaultWsdlPort();
                if (this.showAddDialog(newWsdlPort, ADD_WSDL_PORT_MENU_STRING)) {
                    this._bean.setWsdlPort(newWsdlPort);
                    WsdlPortTreeNode newNode = new WsdlPortTreeNode(this, newWsdlPort);
                    this.insertNode(newNode);
                    this._addWsdlPortMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_RUNTIME_MENU_STRING)) {
                ClientPortRuntimeType newRuntime = this._bean.defaultRuntime();
                if (this.showAddDialog(newRuntime, ADD_RUNTIME_MENU_STRING)) {
                    this._bean.setRuntime(newRuntime);
                    ClientPortRuntimeTreeNode newNode = new ClientPortRuntimeTreeNode(this, newRuntime);
                    this.insertNode(newNode);
                    this._addRuntimeMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(REMOVE_PORT_INFO_MENU_STRING) && this.confirmRemove()) {
                this.getParentNode().remove(this);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof WsdlPortTreeNode) {
            this._bean.removeWsdlPort();
            this.removeNode(node);
            this._addWsdlPortMenuItem.setEnabled(true);
        } else if (node instanceof ClientPortRuntimeTreeNode) {
            this._bean.removeRuntime();
            this.removeNode(node);
            this._addRuntimeMenuItem.setEnabled(true);
        }
    }
}

