/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.exceptions.ExtendedConfigurationException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.MultipleType;
import oracle.oc4j.admin.deploy.spi.xml.ProviderPropertyTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.ProviderPropertyType;

public class ProviderPropertiesTreeNode
extends ConfigTreeNode
implements ActionListener {
    private ConfigBeanNode _parentBean;
    private static final String ADD_PROPERTY_MENU_STRING = "Add Property";
    private JMenuItem _addProviderPropertyMenuItem;
    private ProviderPropertyType[] providerPropertiesType = new ProviderPropertyType[0];
    private Method _readMethod = null;
    private Method _addMethod = null;
    private Method _removeMethod = null;

    public ProviderPropertiesTreeNode(ConfigTreeNode rootNode, MultipleType providerProperties) {
        super(providerProperties);
        this.setRootNode(rootNode);
        this._parentBean = providerProperties.getConfigParent();
        this._addProviderPropertyMenuItem = new JMenuItem(ADD_PROPERTY_MENU_STRING);
        this._addProviderPropertyMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addProviderPropertyMenuItem.setFont(ProviderPropertiesTreeNode.getFont());
        this._addProviderPropertyMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addProviderPropertyMenuItem);
        Class<?> beanClass = this._parentBean.getClass();
        try {
            this._readMethod = beanClass.getMethod("getProperties", null);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._addMethod = beanClass.getMethod("addProperty", ProviderPropertyType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._removeMethod = beanClass.getMethod("removeProperty", ProviderPropertyType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public String viewHeaderString() {
        return "Properties";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        try {
            ProviderPropertyType[] providerProperties = (ProviderPropertyType[])this._readMethod.invoke((Object)this._parentBean, null);
            if (providerProperties != null) {
                for (int i = 0; i < providerProperties.length; ++i) {
                    ProviderPropertyType providerProperty = providerProperties[i];
                    if (providerProperty == null) continue;
                    ProviderPropertyTreeNode providerPropertyTreeNode = new ProviderPropertyTreeNode(this.getRootNode(), providerProperty);
                    this.addChild(providerPropertyTreeNode);
                }
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            ProviderPropertyType newProviderProperty;
            if (event.getActionCommand().equals(ADD_PROPERTY_MENU_STRING) && this.showAddDialog(newProviderProperty = new ProviderPropertyType(this._parentBean, null), ADD_PROPERTY_MENU_STRING)) {
                this._addMethod.invoke((Object)this._parentBean, newProviderProperty);
                ProviderPropertyTreeNode newNode = new ProviderPropertyTreeNode(this, newProviderProperty);
                this.insertNode(newNode);
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof ProviderPropertyTreeNode) {
            try {
                ProviderPropertyType providerProperty = (ProviderPropertyType)node.getConfigBeanNode();
                this._removeMethod.invoke((Object)this._parentBean, providerProperty);
                this.removeNode(node);
            }
            catch (Throwable t) {
                throw new ExtendedConfigurationException(t);
            }
        }
    }
}

