/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.tree.TreePath;
import oracle.oc4j.admin.deploy.gui.ViewableJTree;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTree;
import oracle.oc4j.admin.deploy.spi.xml.ConnectionPoolType;
import oracle.oc4j.admin.deploy.spi.xml.ConnectorFactoryType;
import oracle.oc4j.admin.deploy.spi.xml.ImportedLibrariesType;
import oracle.oc4j.admin.deploy.spi.xml.RarModuleMappingsTreeNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RarModuleConfigBean
extends ConfigBeanNode {
    ConnectorFactoryType[] _connectorFactories = null;
    ConnectionPoolType[] _connectionPools = null;
    protected ImportedLibrariesType _importedLibraries = null;

    public RarModuleConfigBean(DDBean stdBean, ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(stdBean, parent, node);
        this.init();
    }

    public RarModuleConfigBean(ConfigBeanNode parent, Node node) throws ConfigurationException {
        this(null, parent, node);
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "oc4j-connector-factories");
        XMLUtils.writeAttribute(out, indentation, "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        XMLUtils.writeAttribute(out, indentation, "xsi:noNamespaceSchemaLocation", "http://xmlns.oracle.com/oracleas/schema/oc4j-connector-factories-10_0.xsd");
        XMLUtils.writeTagAttributeEnd(out, indentation, "oc4j-connector-factories");
        ConnectorFactoryType.writeXML(out, indentation + "\t", this._connectorFactories);
        ConnectionPoolType.writeXML(out, indentation + "\t", this._connectionPools);
        if (this.getImportedLibraries() != null) {
            this.getImportedLibraries().writeXML(out, indentation + "\t");
        }
        XMLUtils.writeTagEnd(out, indentation, "oc4j-connector-factories");
    }

    public void writeConnectorFactoriesXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        if (this._connectorFactories != null && this._connectorFactories.length > 0) {
            RarModuleConfigBean.writeXML(out, indentation + "\t", this._connectorFactories);
        }
    }

    public void writeConnectionPoolsXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        if (this._connectionPools != null && this._connectionPools.length > 0) {
            RarModuleConfigBean.writeXML(out, indentation + "\t", this._connectionPools);
        }
    }

    private void init() throws ConfigurationException {
        this.setXpath("oc4j-connector-factories");
        Vector<ConnectorFactoryType> connectorFactories = new Vector<ConnectorFactoryType>();
        Vector<ConnectionPoolType> connectionPools = new Vector<ConnectionPoolType>();
        if (this.getNode() != null) {
            Object val = null;
            Node node = this.getNode();
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (name.equals("connector-factory")) {
                    ConnectorFactoryType factory = new ConnectorFactoryType(this, node);
                    connectorFactories.add(factory);
                    continue;
                }
                if (name.equals("connection-pool")) {
                    ConnectionPoolType pool = new ConnectionPoolType(this, node);
                    connectionPools.add(pool);
                    continue;
                }
                if (!name.equals("imported-shared-libraries")) continue;
                ImportedLibrariesType importedLibraries = new ImportedLibrariesType(this, node);
                this.setImportedLibraries(importedLibraries);
            }
        }
        if (connectorFactories.size() > 0) {
            this._connectorFactories = connectorFactories.toArray(new ConnectorFactoryType[0]);
        }
        if (connectionPools.size() > 0) {
            this._connectionPools = connectionPools.toArray(new ConnectionPoolType[0]);
        }
    }

    public ViewableJTree[] subTrees() {
        RarModuleMappingsTreeNode treeNode = new RarModuleMappingsTreeNode(this);
        treeNode.setTreePath(new TreePath(treeNode));
        ConfigTree tree = new ConfigTree(treeNode);
        treeNode.setTree(tree);
        return new ViewableJTree[]{tree};
    }

    public void setConnectorFactories(ConnectorFactoryType[] connectorFactories) {
        ConnectorFactoryType[] oldValue = this._connectorFactories;
        this._connectorFactories = connectorFactories;
        this.firePropertyChange("connectorFactories", oldValue, this._connectorFactories);
    }

    public ConnectorFactoryType[] getConnectorFactories() {
        return this._connectorFactories;
    }

    public ConnectorFactoryType[] defaultConnectorFactories() {
        return new ConnectorFactoryType[0];
    }

    public void addConnectorFactories() {
        if (this._connectorFactories != null) {
            return;
        }
        ConnectorFactoryType[] connectorFactories = new ConnectorFactoryType[]{new ConnectorFactoryType(this, null)};
        this.setConnectorFactories(connectorFactories);
    }

    public void removeConnectorFactories() {
        if (this._connectorFactories == null) {
            return;
        }
        this.setConnectorFactories(null);
    }

    public void addConnectorFactory(ConnectorFactoryType connectorFactory) {
        connectorFactory.setParent(this);
        int existingConnectorFactoriesCnt = 0;
        if (this._connectorFactories != null) {
            existingConnectorFactoriesCnt = this._connectorFactories.length;
        }
        ConnectorFactoryType[] newConnectorFactories = new ConnectorFactoryType[existingConnectorFactoriesCnt + 1];
        for (int n = 0; n < existingConnectorFactoriesCnt; ++n) {
            newConnectorFactories[n] = this._connectorFactories[n];
        }
        newConnectorFactories[existingConnectorFactoriesCnt] = connectorFactory;
        ConnectorFactoryType[] oldValue = this._connectorFactories;
        this._connectorFactories = newConnectorFactories;
        this.firePropertyChange("connectorFactories", oldValue, this._connectorFactories);
    }

    public void removeConnectorFactory(ConnectorFactoryType connectorFactory) {
        int existingConnectorFactoriesCnt = 0;
        if (this._connectorFactories != null) {
            existingConnectorFactoriesCnt = this._connectorFactories.length;
        }
        ConnectorFactoryType[] newConnectorFactories = new ConnectorFactoryType[existingConnectorFactoriesCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingConnectorFactoriesCnt; ++n) {
            if (connectorFactory.equals(this._connectorFactories[n])) continue;
            newConnectorFactories[newIndex++] = this._connectorFactories[n];
        }
        if (newConnectorFactories.length == 0) {
            newConnectorFactories = null;
        }
        ConnectorFactoryType[] oldValue = this._connectorFactories;
        this._connectorFactories = newConnectorFactories;
        this.firePropertyChange("connectorFactories", oldValue, this._connectorFactories);
    }

    public void setConnectionPools(ConnectionPoolType[] connectionPools) {
        ConnectionPoolType[] oldValue = this._connectionPools;
        this._connectionPools = connectionPools;
        this.firePropertyChange("connectionPools", oldValue, this._connectionPools);
    }

    public ConnectionPoolType[] getConnectionPools() {
        return this._connectionPools;
    }

    public ConnectionPoolType[] defaultConnectionPools() {
        return new ConnectionPoolType[0];
    }

    public void addConnectionPools() {
        if (this._connectionPools != null) {
            return;
        }
        ConnectionPoolType[] connectionPools = new ConnectionPoolType[]{new ConnectionPoolType(this, null)};
        this.setConnectionPools(connectionPools);
    }

    public void removeConnectionPools() {
        if (this._connectionPools == null) {
            return;
        }
        this.setConnectionPools(null);
    }

    public void addConnectionPool(ConnectionPoolType connectionPool) {
        connectionPool.setParent(this);
        int existingConnectionPoolsCnt = 0;
        if (this._connectionPools != null) {
            existingConnectionPoolsCnt = this._connectionPools.length;
        }
        ConnectionPoolType[] newConnectionPools = new ConnectionPoolType[existingConnectionPoolsCnt + 1];
        for (int n = 0; n < existingConnectionPoolsCnt; ++n) {
            newConnectionPools[n] = this._connectionPools[n];
        }
        newConnectionPools[existingConnectionPoolsCnt] = connectionPool;
        ConnectionPoolType[] oldValue = this._connectionPools;
        this._connectionPools = newConnectionPools;
        this.firePropertyChange("connectionPools", oldValue, this._connectionPools);
    }

    public void removeConnectionPool(ConnectionPoolType connectionPool) {
        int existingConnectionPoolsCnt = 0;
        if (this._connectionPools != null) {
            existingConnectionPoolsCnt = this._connectionPools.length;
        }
        ConnectionPoolType[] newConnectionPools = new ConnectionPoolType[existingConnectionPoolsCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingConnectionPoolsCnt; ++n) {
            if (connectionPool.equals(this._connectionPools[n])) continue;
            newConnectionPools[newIndex++] = this._connectionPools[n];
        }
        if (newConnectionPools.length == 0) {
            newConnectionPools = null;
        }
        ConnectionPoolType[] oldValue = this._connectionPools;
        this._connectionPools = newConnectionPools;
        this.firePropertyChange("connectionPools", oldValue, this._connectionPools);
    }

    public ImportedLibrariesType getImportedLibraries() {
        return this._importedLibraries;
    }

    public void setImportedLibraries(ImportedLibrariesType importedLibraries) throws ConfigurationException {
        ImportedLibrariesType oldValue = this._importedLibraries;
        this._importedLibraries = importedLibraries;
        this.firePropertyChange("importedLibraries", oldValue, this._importedLibraries);
    }

    public void addImportedLibraries() throws ConfigurationException {
        if (this._importedLibraries != null) {
            return;
        }
        ImportedLibrariesType importedLibraries = new ImportedLibrariesType(this, null);
        this.setImportedLibraries(importedLibraries);
    }

    public void removeImportedLibraries() throws ConfigurationException {
        if (this._importedLibraries == null) {
            return;
        }
        this.setImportedLibraries(null);
    }

    public ImportedLibrariesType defaultImportedLibraries() {
        try {
            return new ImportedLibrariesType(this, null);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }
}

