/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.tree.TreePath;
import oracle.oc4j.admin.deploy.gui.ViewableJTree;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.BooleanType;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTree;
import oracle.oc4j.admin.deploy.spi.xml.EjbModuleConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.GroupNameType;
import oracle.oc4j.admin.deploy.spi.xml.GroupType;
import oracle.oc4j.admin.deploy.spi.xml.SecurityRoleMappingTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.UserNameType;
import oracle.oc4j.admin.deploy.spi.xml.UserType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SecurityRoleMappingConfigBean
extends ConfigBeanNode {
    BooleanType _impliesAll = null;
    BooleanType _oldImpliesAll = null;
    String _name = null;
    GroupType[] _groups = new GroupType[0];
    UserType[] _users = new UserType[0];

    public SecurityRoleMappingConfigBean(DDBean stdBean, ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(stdBean, parent, node);
        this.init();
    }

    protected SecurityRoleMappingConfigBean(DDBean stdBean, ConfigBeanNode parent, Node node, String accessType) throws ConfigurationException {
        super(stdBean, parent, node);
        this.init(accessType);
    }

    public SecurityRoleMappingConfigBean(ConfigBeanNode parent, Node node) throws ConfigurationException {
        this(null, parent, node);
    }

    public void setImpliesAll(BooleanType impliesAll) throws ConfigurationException {
        this._impliesAll = impliesAll;
        this.firePropertyChange("impliesAll", this._oldImpliesAll, this._impliesAll);
        if (this._impliesAll != null) {
            if (this._oldImpliesAll == null) {
                this._oldImpliesAll = this.defaultImpliesAll();
            }
            this._oldImpliesAll.setValue(this._impliesAll.getValue());
        } else {
            this._oldImpliesAll = null;
        }
    }

    public BooleanType getImpliesAll() {
        return this._impliesAll;
    }

    public BooleanType defaultImpliesAll() {
        try {
            return new BooleanType(this, "false");
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public String getName() {
        return this._name;
    }

    public String defaultName() {
        if (this._name != null) {
            return this._name;
        }
        return "";
    }

    public String key() {
        return this.getName();
    }

    public String beanKey() {
        return "role-name";
    }

    public void setGroups(GroupType[] groups) throws ConfigurationException {
        GroupType[] oldValue = this._groups;
        this._groups = groups;
        if (this._groups == null) {
            this._groups = new GroupType[0];
        } else {
            for (int n = 0; n < this._groups.length; ++n) {
                this._groups[n].setParent(this);
            }
        }
        this.firePropertyChange("groups", oldValue, this._groups);
    }

    public GroupType[] getGroups() {
        return this._groups;
    }

    public GroupType[] defaultGroups() {
        GroupType[] groups = new GroupType[1];
        GroupType group = new GroupType(this);
        GroupNameType groupName = new GroupNameType(group);
        groupName.setValue("");
        group.setName(groupName);
        groups[0] = group;
        return groups;
    }

    public void addGroup(GroupType group) {
        group.setParent(this);
        int existingGroupsCnt = 0;
        if (this._groups != null) {
            existingGroupsCnt = this._groups.length;
        }
        GroupType[] newGroups = new GroupType[existingGroupsCnt + 1];
        for (int n = 0; n < existingGroupsCnt; ++n) {
            newGroups[n] = this._groups[n];
        }
        newGroups[existingGroupsCnt] = group;
        GroupType[] oldValue = this._groups;
        this._groups = newGroups;
        this.firePropertyChange("groups", oldValue, this._groups);
    }

    public void removeGroup(GroupType group) {
        int existingGroupsCnt = 0;
        if (this._groups != null) {
            existingGroupsCnt = this._groups.length;
        }
        GroupType[] newGroups = new GroupType[existingGroupsCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingGroupsCnt; ++n) {
            if (group.equals(this._groups[n])) continue;
            newGroups[newIndex++] = this._groups[n];
        }
        GroupType[] oldValue = this._groups;
        this._groups = newGroups;
        this.firePropertyChange("groups", oldValue, this._groups);
    }

    public void setUsers(UserType[] users) throws ConfigurationException {
        UserType[] oldValue = this._users;
        this._users = users;
        if (this._users == null) {
            this._users = new UserType[0];
        } else {
            for (int n = 0; n < this._users.length; ++n) {
                this._users[n].setParent(this);
            }
        }
        this.firePropertyChange("users", oldValue, this._users);
    }

    public UserType[] getUsers() {
        return this._users;
    }

    public UserType[] defaultUsers() {
        UserType[] users = new UserType[1];
        UserType user = new UserType(this);
        UserNameType userName = new UserNameType(user);
        userName.setValue("");
        user.setName(userName);
        users[0] = user;
        return users;
    }

    public void addUser(UserType user) {
        user.setParent(this);
        int existingUsersCnt = 0;
        if (this._users != null) {
            existingUsersCnt = this._users.length;
        }
        UserType[] newUsers = new UserType[existingUsersCnt + 1];
        for (int n = 0; n < existingUsersCnt; ++n) {
            newUsers[n] = this._users[n];
        }
        newUsers[existingUsersCnt] = user;
        UserType[] oldValue = this._users;
        this._users = newUsers;
        this.firePropertyChange("users", oldValue, this._users);
    }

    public void removeUser(UserType user) {
        int existingUsersCnt = 0;
        if (this._users != null) {
            existingUsersCnt = this._users.length;
        }
        UserType[] newUsers = new UserType[existingUsersCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingUsersCnt; ++n) {
            if (user.equals(this._users[n])) continue;
            newUsers[newIndex++] = this._users[n];
        }
        UserType[] oldValue = this._users;
        this._users = newUsers;
        this.firePropertyChange("users", oldValue, this._users);
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "security-role-mapping");
        XMLUtils.writeAttribute(out, indentation, "impliesAll", this._impliesAll);
        XMLUtils.writeAttribute(out, indentation, "name", this._name);
        XMLUtils.writeTagAttributeEnd(out, indentation, "security-role-mapping");
        GroupType.writeXML(out, indentation, this._groups);
        UserType.writeXML(out, indentation, this._users);
        XMLUtils.writeTagEnd(out, indentation, "security-role-mapping");
    }

    protected void init(String accessType) throws ConfigurationException {
    }

    protected void init() throws ConfigurationException {
        ConfigBeanNode parent = this.getConfigParent();
        if (this._xpath == null) {
            if (parent instanceof EjbModuleConfigBean) {
                this.setXpath("assembly-descriptor/security-role-mapping");
            } else {
                this.setXpath("security-role-mapping");
            }
        }
        Vector<GroupType> groups = new Vector<GroupType>();
        Vector<UserType> users = new Vector<UserType>();
        if (this.getNode() != null) {
            String val = null;
            Node node = this.getNode();
            val = XMLUtils.getAttribute(node, "impliesAll");
            if (val != null && !val.trim().equals("")) {
                BooleanType impliesAll = this.defaultImpliesAll();
                impliesAll.setValue(val);
                this.setImpliesAll(impliesAll);
            }
            if ((val = XMLUtils.getAttribute(node, "name")) != null && !val.trim().equals("")) {
                this._name = val;
            }
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (name.equals("group")) {
                    GroupType groupType = new GroupType(this);
                    GroupNameType groupNameType = new GroupNameType(groupType);
                    groupNameType.setValue(XMLUtils.getAttribute(node, "name"));
                    groupType.setName(groupNameType);
                    groups.add(groupType);
                }
                if (!name.equals("user")) continue;
                UserType userType = new UserType(this);
                UserNameType userNameType = new UserNameType(userType);
                userNameType.setValue(XMLUtils.getAttribute(node, "name"));
                userType.setName(userNameType);
                users.add(userType);
            }
        } else if (this.getDDBean() != null && this.getDDBean().getText(this.beanKey()) != null) {
            this._name = this.getDDBean().getText(this.beanKey())[0];
        }
        this._groups = groups.toArray(this._groups);
        this._users = users.toArray(this._users);
    }

    public ViewableJTree[] subTrees() {
        SecurityRoleMappingTreeNode treeNode = new SecurityRoleMappingTreeNode(this);
        treeNode.setTreePath(new TreePath(treeNode));
        ConfigTree tree = new ConfigTree(treeNode);
        treeNode.setTree(tree);
        return new ViewableJTree[]{tree};
    }

    public void writeGroupsXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        GroupType.writeXML(out, indentation, this._groups);
    }

    public void writeUsersXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        UserType.writeXML(out, indentation, this._users);
    }
}

