/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SecurityRoleRefType
extends ConfigBeanNode {
    String description;
    String roleName;
    String roleLink;

    public SecurityRoleRefType(ConfigBeanNode parent, Node node) {
        super(null, parent, node);
        this.init();
    }

    public void init() {
        this.setXpath("security-role-ref");
        Node node = this.getNode();
        if (node != null) {
            NodeList childNodes = node.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                String nodeName = childNodes.item(i).getNodeName();
                if (nodeName.equals("role-name")) {
                    this.roleName = XMLUtils.getValue(childNodes.item(i));
                    continue;
                }
                if (nodeName.equals("description")) {
                    this.description = XMLUtils.getValue(childNodes.item(i));
                    continue;
                }
                if (!nodeName.equals("role-link")) continue;
                this.roleLink = XMLUtils.getValue(childNodes.item(i));
            }
        }
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagStart(out, indentation, "security-role-ref");
        XMLUtils.writeTagWithValue(out, indentation + "\t", "description", this.description);
        XMLUtils.writeTagWithValue(out, indentation + "\t", "role-name", this.roleName);
        XMLUtils.writeTagWithValue(out, indentation + "\t", "role-link", this.roleLink);
        XMLUtils.writeTagEnd(out, indentation, "security-role-ref");
    }

    public String getDescription() {
        return this.description;
    }

    public String getRoleLink() {
        return this.roleLink;
    }

    public String getRoleName() {
        return this.roleName;
    }
}

